/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swing.BasicPanel;

public class LinkListener
extends MouseInputAdapter {
    protected BasicPanel panel;
    private Box prev;

    public LinkListener(BasicPanel panel) {
        this.panel = panel;
    }

    public void mouseEntered(MouseEvent evt) {
        Box box = this.panel.find(evt);
        this.setCursor(box);
    }

    public void mouseExited(MouseEvent evt) {
        Box box = this.panel.find(evt);
        this.setCursor(box);
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
        Box box = this.panel.find(evt);
        if (box == null) {
            return;
        }
        Element elem = box.element;
        if (elem == null) {
            return;
        }
        String uri = this.findLink(elem);
        if (uri != null) {
            this.linkClicked(uri);
        }
    }

    private String findLink(Element elem) {
        String uri = null;
        Node n = elem;
        while (uri == null && n.getNodeType() == 1) {
            uri = this.panel.getSharedContext().getNamespaceHandler().getLinkUri((Element)n);
            n = n.getParentNode();
        }
        return uri;
    }

    public void mouseMoved(MouseEvent evt) {
        Box box = this.panel.find(evt);
        this.setCursor(box);
    }

    public void mouseDragged(MouseEvent evt) {
        Box box = this.panel.find(evt);
        this.setCursor(box);
    }

    public void linkClicked(String uri) {
        this.panel.setDocumentRelative(uri);
        this.panel.repaint();
    }

    private void setCursor(Box box) {
        if (this.prev == box || box == null || box.element == null) {
            return;
        }
        if (this.findLink(box.element) != null) {
            if (!this.panel.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.panel.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (!this.panel.getCursor().equals(Cursor.getPredefinedCursor(0))) {
            this.panel.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.prev = box;
    }

    public void reset() {
        this.prev = null;
    }
}

