/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.render.AWTFSImage;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.util.GraphicsUtil;
import org.xhtmlrenderer.util.XRLog;

public class NaiveUserAgent
implements UserAgentCallback {
    private int imageCacheCapacity = 16;
    private LinkedHashMap imageCache = new LinkedHashMap(this.imageCacheCapacity, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > NaiveUserAgent.this.imageCacheCapacity;
        }
    };
    private String baseURL;

    protected InputStream getInputStream(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            is = new URL(uri).openStream();
        }
        catch (MalformedURLException e) {
            XRLog.exception("bad URL given: " + uri, e);
        }
        catch (IOException e) {
            XRLog.exception("IO problem for " + uri, e);
        }
        return is;
    }

    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.getInputStream(uri));
    }

    public ImageResource getImageResource(String uri) {
        InputStream is;
        ImageResource ir = null;
        ir = (ImageResource)this.imageCache.get(uri = this.resolveURI(uri));
        if (ir == null && (is = this.getInputStream(uri)) != null) {
            try {
                Image img = ImageIO.read(is);
                img = GraphicsUtil.cleanImage(img);
                ir = new ImageResource(new AWTFSImage(img));
                this.imageCache.put(uri, ir);
            }
            catch (IOException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + uri + "'", e);
            }
        }
        if (ir == null) {
            ir = new ImageResource(null);
        }
        return ir;
    }

    public XMLResource getXMLResource(String uri) {
        return XMLResource.load(this.getInputStream(uri));
    }

    public boolean isVisited(String uri) {
        return false;
    }

    public void setBaseURL(String url) {
        this.baseURL = url;
    }

    public String resolveURI(String uri) {
        URL result;
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this.baseURL == null) {
            try {
                result = new URL(uri);
                this.setBaseURL(result.toExternalForm());
            }
            catch (MalformedURLException e) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    XRLog.exception("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri);
                    return null;
                }
            }
        }
        try {
            result = new URL(new URL(this.baseURL), uri);
            ret = result.toString();
        }
        catch (MalformedURLException e1) {
            XRLog.exception("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this.baseURL);
        }
        return ret;
    }

    public String getBaseURL() {
        return this.baseURL;
    }
}

