/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Image;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.AWTFSImage;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.swing.SwingReplacedElement;

public class SwingReplacedElementFactory
implements ReplacedElementFactory {
    protected HashMap imageComponents;
    protected LinkedHashMap forms;

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.element;
        JComponent cc = null;
        if (e == null) {
            return null;
        }
        if (e.getNodeName().equals("img")) {
            cc = this.getImageComponent(e);
            if (cc == null) {
                JButton jb = null;
                Image im = null;
                FSImage fsImage = uac.getImageResource(e.getAttribute("src")).getImage();
                if (fsImage != null) {
                    im = ((AWTFSImage)fsImage).getImage();
                }
                if (im == null) {
                    jb = new JButton("Image unreachable. " + e.getAttribute("alt"));
                } else {
                    Image i2 = im.getScaledInstance(cssWidth, cssHeight, 2);
                    ImageIcon ii = new ImageIcon(i2, e.getAttribute("alt"));
                    jb = new JButton(ii);
                }
                jb.setBorder(BorderFactory.createEmptyBorder());
                jb.setSize(jb.getPreferredSize());
                this.addImageComponent(e, jb);
                cc = jb;
            }
        } else {
            Element parentForm = this.getParentForm(e);
            XhtmlForm form = this.getForm(parentForm);
            if (form == null) {
                form = new XhtmlForm(uac, parentForm);
                this.addForm(parentForm, form);
            }
            cc = form.addComponent(e);
        }
        if (cc == null) {
            return null;
        }
        SwingReplacedElement result = new SwingReplacedElement(cc);
        if (c.isInteractive()) {
            c.getCanvas().add(cc);
        }
        return result;
    }

    protected void addImageComponent(Element e, JComponent cc) {
        if (this.imageComponents == null) {
            this.imageComponents = new HashMap();
        }
        this.imageComponents.put(e, cc);
    }

    protected void addForm(Element e, XhtmlForm f) {
        if (this.forms == null) {
            this.forms = new LinkedHashMap();
        }
        this.forms.put(e, f);
    }

    protected JComponent getImageComponent(Element e) {
        if (this.imageComponents == null) {
            return null;
        }
        return (JComponent)this.imageComponents.get(e);
    }

    protected XhtmlForm getForm(Element e) {
        if (this.forms == null) {
            return null;
        }
        return (XhtmlForm)this.forms.get(e);
    }

    protected Element getParentForm(Element e) {
        Node n = e;
        while ((n = n.getParentNode()).getNodeType() == 1 && !n.getNodeName().equals("form")) {
        }
        if (n.getNodeType() != 1) {
            return null;
        }
        return (Element)n;
    }
}

