/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

class WindowDimensions {
    private Point loc;
    private Dimension size;
    private Insets insets;
    private boolean isClientSizeSet;

    public WindowDimensions(int n, int n2, int n3, int n4, boolean bl) {
        this(new Rectangle(n, n2, n3, n4), null, bl);
    }

    public WindowDimensions(Rectangle rectangle, Insets insets, boolean bl) {
        if (rectangle == null) {
            throw new IllegalArgumentException("Client bounds can't be null");
        }
        this.isClientSizeSet = bl;
        this.loc = rectangle.getLocation();
        this.size = rectangle.getSize();
        this.setInsets(insets);
    }

    public WindowDimensions(Point point, Dimension dimension, Insets insets, boolean bl) {
        this(new Rectangle(point, dimension), insets, bl);
    }

    public WindowDimensions(Rectangle rectangle, boolean bl) {
        this(rectangle, null, bl);
    }

    public WindowDimensions(WindowDimensions windowDimensions) {
        this.loc = new Point(windowDimensions.loc);
        this.size = new Dimension(windowDimensions.size);
        this.insets = windowDimensions.insets != null ? (Insets)windowDimensions.insets.clone() : new Insets(0, 0, 0, 0);
        this.isClientSizeSet = windowDimensions.isClientSizeSet;
    }

    public Rectangle getClientRect() {
        if (this.isClientSizeSet) {
            return new Rectangle(this.loc, this.size);
        }
        if (this.insets != null) {
            return new Rectangle(this.loc.x, this.loc.y, this.size.width - (this.insets.left + this.insets.right), this.size.height - (this.insets.top + this.insets.bottom));
        }
        return new Rectangle(this.loc, this.size);
    }

    public void setClientSize(Dimension dimension) {
        this.size = new Dimension(dimension);
        this.isClientSizeSet = true;
    }

    public void setClientSize(int n, int n2) {
        this.size = new Dimension(n, n2);
        this.isClientSizeSet = true;
    }

    public Dimension getClientSize() {
        return this.getClientRect().getSize();
    }

    public void setSize(int n, int n2) {
        this.size = new Dimension(n, n2);
        this.isClientSizeSet = false;
    }

    public Dimension getSize() {
        return this.getBounds().getSize();
    }

    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    public Rectangle getBounds() {
        if (this.isClientSizeSet) {
            Rectangle rectangle = new Rectangle(this.loc, this.size);
            rectangle.width += this.insets.left + this.insets.right;
            rectangle.height += this.insets.top + this.insets.bottom;
            return rectangle;
        }
        return new Rectangle(this.loc, this.size);
    }

    public Point getLocation() {
        return new Point(this.loc);
    }

    public void setLocation(int n, int n2) {
        this.loc = new Point(n, n2);
    }

    public void setInsets(Insets insets) {
        Insets insets2 = this.insets = insets != null ? (Insets)insets.clone() : new Insets(0, 0, 0, 0);
        if (!this.isClientSizeSet) {
            if (this.size.width < this.insets.left + this.insets.right) {
                this.size.width = this.insets.left + this.insets.right;
            }
            if (this.size.height < this.insets.top + this.insets.bottom) {
                this.size.height = this.insets.top + this.insets.bottom;
            }
        }
    }

    public boolean isClientSizeSet() {
        return this.isClientSizeSet;
    }

    public String toString() {
        return "[" + this.loc + ", " + this.size + "(" + (this.isClientSizeSet ? "client" : "bounds") + ")+" + this.insets + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof WindowDimensions)) {
            return false;
        }
        WindowDimensions windowDimensions = (WindowDimensions)object;
        return windowDimensions.insets.equals(this.insets) && this.getClientRect().equals(windowDimensions.getClientRect()) && this.getBounds().equals(windowDimensions.getBounds());
    }

    public int hashCode() {
        return (this.insets == null ? 0 : this.insets.hashCode()) ^ this.getClientRect().hashCode() ^ this.getBounds().hashCode();
    }
}

