/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketAdaptor;
import sun.nio.ch.SocketDispatcher;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class SocketChannelImpl
extends SocketChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long readerThread = 0L;
    private volatile long writerThread = 0L;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLED = 3;
    private int state = -1;
    private SocketAddress localAddress = null;
    private SocketAddress remoteAddress = null;
    private boolean isInputOpen = true;
    private boolean isOutputOpen = true;
    private boolean readyToConnect = false;
    private SocketOpts.IP.TCP options = null;
    private Socket socket = null;
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;

    SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, InetSocketAddress inetSocketAddress) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 2;
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = SocketAdaptor.create(this);
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        // MONITORENTER : object
        if (!this.ensureReadOpen()) {
            // MONITOREXIT : object
            return -1;
        }
        int n2 = 0;
        try {
            this.begin();
            if (!this.isOpen()) {
                int n3 = 0;
                Object var6_6 = null;
                this.readerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (n2 <= 0 && !this.isInputOpen) {
                    // MONITOREXIT : object2
                    // MONITOREXIT : object
                    return -1;
                }
                // MONITOREXIT : object2
                assert (IOStatus.check(n2));
                // MONITOREXIT : object
                return n3;
            }
            this.readerThread = NativeThread.current();
            while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var6_7 = null;
            this.readerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.readerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1;
            }
            // MONITOREXIT : object3
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (n2 <= 0 && !this.isInputOpen) {
            // MONITOREXIT : object4
            // MONITOREXIT : object
            return -1;
        }
        // MONITOREXIT : object4
        if ($assertionsDisabled) return n;
        if (IOStatus.check(n2)) return n;
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        long l;
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        // MONITORENTER : object
        if (!this.ensureReadOpen()) {
            // MONITOREXIT : object
            return -1L;
        }
        long l2 = 0L;
        try {
            this.begin();
            if (!this.isOpen()) {
                long l3 = 0L;
                Object var8_6 = null;
                this.readerThread = 0L;
                this.end(l2 > 0L || l2 == -2L);
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (l2 <= 0L && !this.isInputOpen) {
                    // MONITOREXIT : object2
                    // MONITOREXIT : object
                    return -1L;
                }
                // MONITOREXIT : object2
                assert (IOStatus.check(l2));
                // MONITOREXIT : object
                return l3;
            }
            this.readerThread = NativeThread.current();
            while ((l2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
            Object var8_7 = null;
            this.readerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.readerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (l2 <= 0L && !this.isInputOpen) {
                // MONITOREXIT : object3
                // MONITOREXIT : object
                return -1L;
            }
            // MONITOREXIT : object3
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (l2 <= 0L && !this.isInputOpen) {
            // MONITOREXIT : object4
            // MONITOREXIT : object
            return -1L;
        }
        // MONITOREXIT : object4
        if ($assertionsDisabled) return l;
        if (IOStatus.check(l2)) return l;
        throw new AssertionError();
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.read0(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        // MONITORENTER : object
        this.ensureWriteOpen();
        int n2 = 0;
        try {
            this.begin();
            if (!this.isOpen()) {
                int n3 = 0;
                Object var6_6 = null;
                this.writerThread = 0L;
                this.end(n2 > 0 || n2 == -2);
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (n2 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                // MONITOREXIT : object2
                assert (IOStatus.check(n2));
                // MONITOREXIT : object
                return n3;
            }
            this.writerThread = NativeThread.current();
            while ((n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
            Object var6_7 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.writerThread = 0L;
            this.end(n2 > 0 || n2 == -2);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (n2 <= 0 && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (n2 <= 0 && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object4
        if ($assertionsDisabled) return n;
        if (IOStatus.check(n2)) return n;
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long write0(ByteBuffer[] byteBufferArray) throws IOException {
        long l;
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        // MONITORENTER : object
        this.ensureWriteOpen();
        long l2 = 0L;
        try {
            this.begin();
            if (!this.isOpen()) {
                long l3 = 0L;
                Object var8_6 = null;
                this.writerThread = 0L;
                this.end(l2 > 0L || l2 == -2L);
                Object object2 = this.stateLock;
                // MONITORENTER : object2
                if (l2 <= 0L && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
                // MONITOREXIT : object2
                assert (IOStatus.check(l2));
                // MONITOREXIT : object
                return l3;
            }
            this.writerThread = NativeThread.current();
            while ((l2 = IOUtil.write(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
            }
            l = IOStatus.normalize(l2);
            Object var8_7 = null;
            this.writerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.writerThread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            Object object3 = this.stateLock;
            // MONITORENTER : object3
            if (l2 <= 0L && !this.isOutputOpen) {
                throw new AsynchronousCloseException();
            }
            // MONITOREXIT : object3
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(l2)) throw throwable;
            throw new AssertionError();
        }
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (l2 <= 0L && !this.isOutputOpen) {
            throw new AsynchronousCloseException();
        }
        // MONITOREXIT : object4
        if ($assertionsDisabled) return l;
        if (IOStatus.check(l2)) return l;
        throw new AssertionError();
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.write0(Util.subsequence(byteBufferArray, n, n2));
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.options == null) {
                SocketOptsImpl.Dispatcher dispatcher = new SocketOptsImpl.Dispatcher(){

                    int getInt(int n) throws IOException {
                        return Net.getIntOption(SocketChannelImpl.this.fd, n);
                    }

                    void setInt(int n, int n2) throws IOException {
                        Net.setIntOption(SocketChannelImpl.this.fd, n, n2);
                    }
                };
                this.options = new SocketOptsImpl.IP.TCP(dispatcher);
            }
            return this.options;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return true;
            }
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2 && this.localAddress == null) {
                this.localAddress = Net.localAddress(this.fd);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpenAndUnconnected();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = Net.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(SocketAddress socketAddress) throws IOException {
        int n = 0;
        boolean bl = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpenAndUnconnected();
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                Object object3 = this.blockingLock();
                synchronized (object3) {
                    int n2 = 0;
                    try {
                        try {
                            this.begin();
                            if (this.isOpen()) {
                                this.readerThread = NativeThread.current();
                                while ((n2 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n)) == -3 && this.isOpen()) {
                                }
                            }
                            Object var11_10 = null;
                            this.readerThread = 0L;
                            this.end(n2 > 0 || n2 == -2);
                        }
                        catch (Throwable throwable) {
                            Object var11_11 = null;
                            this.readerThread = 0L;
                            this.end(n2 > 0 || n2 == -2);
                            assert (IOStatus.check(n2));
                            throw throwable;
                        }
                        assert (IOStatus.check(n2));
                    }
                    catch (IOException iOException) {
                        this.close();
                        throw iOException;
                    }
                    Object object4 = this.stateLock;
                    synchronized (object4) {
                        this.remoteAddress = inetSocketAddress;
                        if (n2 > 0) {
                            this.state = 2;
                            return true;
                        }
                        if (!this.isBlocking()) {
                            this.state = 1;
                        } else assert (false);
                    }
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishConnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3;
                Object object4 = this.stateLock;
                synchronized (object4) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 2) {
                        return true;
                    }
                    if (this.state != 1) {
                        throw new NoConnectionPendingException();
                    }
                }
                int n = 0;
                try {
                    try {
                        this.begin();
                        if (this.isOpen()) {
                            object3 = this.blockingLock();
                            synchronized (object3) {
                                this.readerThread = NativeThread.current();
                                if (!this.isBlocking()) {
                                    while ((n = SocketChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                                    }
                                } else {
                                    while ((n = SocketChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                                    }
                                }
                            }
                        }
                        Object var7_9 = null;
                        this.readerThread = 0L;
                        this.end(n > 0 || n == -2);
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        this.readerThread = 0L;
                        this.end(n > 0 || n == -2);
                        assert (IOStatus.check(n));
                        throw throwable;
                    }
                    assert (IOStatus.check(n));
                }
                catch (IOException iOException) {
                    this.close();
                    throw iOException;
                }
                if (n > 0) {
                    object3 = this.stateLock;
                    synchronized (object3) {
                        this.state = 2;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isInputOpen = false;
            SocketChannelImpl.shutdown(this.fd, 0);
            long l = this.readerThread;
            if (l != 0L) {
                NativeThread.signal(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isOutputOpen = false;
            SocketChannelImpl.shutdown(this.fd, 1);
            long l = this.writerThread;
            if (l != 0L) {
                NativeThread.signal(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            nd.preClose(this.fd);
            long l = this.readerThread;
            if (l != 0L) {
                NativeThread.signal(l);
            }
            if ((l = this.writerThread) != 0L) {
                NativeThread.signal(l);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                return;
            }
            if (this.state == -1) {
                this.state = 3;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 3;
        }
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            return false;
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            this.readyToConnect = true;
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 1) != 0 && this.state == 2) {
            n5 |= 1;
        }
        if ((n & 4) != 0 && (n3 & 8) != 0 && (this.state == 0 || this.state == 1)) {
            n5 |= 8;
            this.readyToConnect = true;
        }
        if ((n & 4) != 0 && (n3 & 4) != 0 && this.state == 2) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 4;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSuperclass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuffer.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("connected");
                        if (!this.isInputOpen) {
                            stringBuffer.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        stringBuffer.append(" oshut");
                    }
                }
                if (this.localAddress() != null) {
                    stringBuffer.append(" local=");
                    stringBuffer.append(this.localAddress().toString());
                }
                if (this.remoteAddress() != null) {
                    stringBuffer.append(" remote=");
                    stringBuffer.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    private static native void shutdown(FileDescriptor var0, int var1) throws IOException;

    static {
        Util.load();
        nd = new SocketDispatcher();
    }
}

