/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertificateException;
import COM.claymoresystems.cert.Pickledx509;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParseException;
import cryptix.asn1.lang.Parser;
import cryptix.util.core.ArrayUtil;
import java.io.Reader;
import java.util.Vector;

public class CertContext {
    Vector root_list = new Vector();
    static Parser parser = new Parser((Reader)new Pickledx509());
    static ASNSpecification spec;

    public CertContext() {
    }

    public CertContext(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.addRoot((byte[])vector.elementAt(i));
            }
        }
    }

    public static ASNSpecification getSpec() {
        return spec;
    }

    public void addRoot(byte[] byArray) {
        X509Cert x509Cert;
        try {
            x509Cert = new X509Cert(byArray);
        }
        catch (CertificateException certificateException) {
            SSLDebug.debug(32, "Couldn't parse. Skipping cert", byArray);
            return;
        }
        this.root_list.addElement(x509Cert);
        SSLDebug.debug(32, "Adding root with DN", x509Cert.getSubjectDER());
    }

    public Vector getRootList() {
        return this.root_list;
    }

    public boolean isRoot(byte[] byArray) {
        for (int i = 0; i < this.root_list.size(); ++i) {
            byte[] byArray2 = ((X509Cert)this.root_list.elementAt(i)).getDER();
            if (!ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2)) continue;
            return true;
        }
        return false;
    }

    public X509Cert signedByRoot(byte[] byArray) {
        for (int i = 0; i < this.root_list.size(); ++i) {
            X509Cert x509Cert = (X509Cert)this.root_list.elementAt(i);
            byte[] byArray2 = x509Cert.getSubjectDER();
            if (!ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2)) continue;
            return x509Cert;
        }
        return null;
    }

    static {
        parser.disable_tracing();
        try {
            spec = parser.Specification(false);
        }
        catch (ParseException parseException) {
            throw new InternalError(parseException.toString());
        }
    }
}

