/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.EAYDSAPrivateKey;
import COM.claymoresystems.cert.X509DSAPublicKey;
import COM.claymoresystems.cert.X509Name;
import COM.claymoresystems.cert.X509RSAPrivateKey;
import COM.claymoresystems.cert.X509RSAPublicKey;
import COM.claymoresystems.crypto.EAYEncryptedPrivateKey;
import COM.claymoresystems.ptls.LoadProviders;
import cryptix.util.mime.Base64OutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAKeyPairGenerator;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class CertRequest {
    public static KeyPair generateKey(String string, int n, String string2, BufferedWriter bufferedWriter, boolean bl) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
        Object object;
        KeyPairGenerator keyPairGenerator;
        if (string.equals("DSA")) {
            keyPairGenerator = KeyPairGenerator.getInstance(string);
            object = (DSAKeyPairGenerator)((Object)keyPairGenerator);
            object.initialize(n, bl, new SecureRandom());
        } else {
            keyPairGenerator = KeyPairGenerator.getInstance(string, "Cryptix");
            keyPairGenerator.initialize(n);
        }
        object = keyPairGenerator.generateKeyPair();
        Object object2 = string.equals("DSA") ? new EAYDSAPrivateKey((DSAPrivateKey)((KeyPair)object).getPrivate()) : new X509RSAPrivateKey((CryptixRSAPrivateKey)((KeyPair)object).getPrivate());
        EAYEncryptedPrivateKey.writePrivateKey(object2, string2.getBytes(), bufferedWriter);
        return object;
    }

    public static byte[] makeSPKACRequest(KeyPair keyPair) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        Object object2 = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            object2 = new X509DSAPublicKey((DSAPublicKey)object2);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            object2 = new X509RSAPublicKey((CryptixRSAPublicKey)object2);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = object2.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray5);
        DERUtils.encodeIA5String("Challenge", byteArrayOutputStream);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, object2);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static byte[] makePKCS10Request(KeyPair keyPair, X509Name x509Name) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        Object object2 = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            object2 = new X509DSAPublicKey((DSAPublicKey)object2);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            object2 = new X509RSAPublicKey((CryptixRSAPublicKey)object2);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = object2.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
        byteArrayOutputStream.write(x509Name.getNameDER());
        byteArrayOutputStream.write(byArray5);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, object2);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static byte[] makeSelfSignedCert(KeyPair keyPair, X509Name x509Name, int n) throws IOException {
        byte[] byArray;
        Object object;
        String string;
        byte[] byArray2;
        PrivateKey privateKey = keyPair.getPrivate();
        Object object2 = keyPair.getPublic();
        String string2 = privateKey.getAlgorithm();
        byte[] byArray3 = new byte[]{48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0};
        byte[] byArray4 = new byte[]{48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0};
        if (string2.equals("DSA")) {
            byArray2 = byArray3;
            string = "DSA";
            object2 = new X509DSAPublicKey((DSAPublicKey)object2);
        } else if (string2.equals("RSA")) {
            byArray2 = byArray4;
            string = "SHA-1/RSA/PKCS#1";
            object2 = new X509RSAPublicKey((CryptixRSAPublicKey)object2);
        } else {
            throw new InternalError("Unknown algorithm " + string2);
        }
        byte[] byArray5 = object2.getEncoded();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeInteger(new BigInteger("0"), byteArrayOutputStream);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(x509Name.getNameDER());
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        long l = System.currentTimeMillis();
        long l2 = n;
        long l3 = l + l2 * 1000L;
        DERUtils.encodeUTCTime(l, byteArrayOutputStream2);
        DERUtils.encodeUTCTime(l3, byteArrayOutputStream2);
        DERUtils.encodeSequence(byteArrayOutputStream2, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(x509Name.getNameDER());
        byteArrayOutputStream.write(byArray5);
        byte[] byArray6 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray6, (OutputStream)byteArrayOutputStream);
        byte[] byArray7 = byteArrayOutputStream.toByteArray();
        try {
            object = Signature.getInstance(string);
            ((Signature)object).initSign(privateKey);
            ((Signature)object).update(byArray7);
            byArray = ((Signature)object).sign();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray2);
        if (string2.equals("RSA")) {
            byArray = CertRequest.fitSignature(byArray, object2);
        }
        DERUtils.encodeBitString(byArray, byteArrayOutputStream);
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence((byte[])object, (OutputStream)byteArrayOutputStream);
        byte[] byArray8 = byteArrayOutputStream.toByteArray();
        return byArray8;
    }

    public static X509Name makeSimpleDN(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray = (String[])vector.elementAt(i);
            Vector<String[]> vector3 = new Vector<String[]>();
            String[] stringArray2 = new String[]{new String(stringArray[0]), new String(stringArray[1])};
            vector3.addElement(stringArray2);
            vector2.addElement(vector3);
        }
        return new X509Name(vector2);
    }

    protected static byte[] fitSignature(byte[] byArray, PublicKey publicKey) {
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)publicKey;
        int n = cryptixRSAPublicKey.getModulus().bitLength();
        int n2 = n / 8;
        if (byArray.length == (n2 += n % 8 > 0 ? 1 : 0)) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length < n2) {
            int n3;
            for (n3 = 0; n3 < n2 - byArray.length; ++n3) {
                byArray2[n3] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        } else {
            int n4;
            for (n4 = 0; n4 < byArray.length - n2; ++n4) {
                if (byArray[n4] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(byArray, n4, byArray2, 0, n2);
        }
        return byArray2;
    }

    private static X509Name makeSuperSimpleDN(String string) {
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        String[] stringArray3 = new String[2];
        String[] stringArray4 = new String[2];
        stringArray[0] = "C";
        stringArray[1] = "US";
        stringArray2[0] = "O";
        stringArray2[1] = "Snake Oil, Inc.";
        stringArray3[0] = "OU";
        stringArray3[1] = "Test";
        stringArray4[0] = "CN";
        stringArray4[1] = string;
        vector.addElement(stringArray);
        vector.addElement(stringArray2);
        vector.addElement(stringArray3);
        vector.addElement(stringArray4);
        return CertRequest.makeSimpleDN(vector);
    }

    public static void main(String[] stringArray) throws IOException, Exception {
        String string;
        byte[] byArray;
        String string2 = stringArray[0];
        String string3 = null;
        int n = 0;
        String string4 = stringArray.length >= 2 ? stringArray[1] : "DSA";
        if (stringArray.length >= 3) {
            if (stringArray[2].equals("SPKAC")) {
                n = 0;
            } else if (stringArray[2].equals("PKCS10")) {
                n = 1;
            } else if (stringArray[2].equals("X509")) {
                n = 2;
            } else {
                throw new InternalError("Unknown type " + stringArray[2]);
            }
        }
        if (n == 1 || n == 2) {
            if (stringArray.length != 4) {
                throw new InternalError("Must supply common name for type" + n);
            }
            string3 = stringArray[3];
        }
        int n2 = 1024;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string5 = bufferedReader.readLine();
        FileWriter fileWriter = new FileWriter(string2);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        KeyPair keyPair = CertRequest.generateKey(string4, n2, string5, bufferedWriter, true);
        switch (n) {
            case 0: {
                byArray = CertRequest.makeSPKACRequest(keyPair);
                break;
            }
            case 1: {
                byArray = CertRequest.makePKCS10Request(keyPair, CertRequest.makeSuperSimpleDN(string3));
                break;
            }
            case 2: {
                byArray = CertRequest.makeSelfSignedCert(keyPair, CertRequest.makeSuperSimpleDN(string3), 30000000);
                break;
            }
            default: {
                throw new InternalError("Bad type");
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)byteArrayOutputStream);
        base64OutputStream.write(byArray);
        base64OutputStream.flush();
        base64OutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader2 = new InputStreamReader(byteArrayInputStream);
        BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
        System.out.println(string5);
        switch (n) {
            case 1: {
                System.out.println("-----BEGIN CERTIFICATE REQUEST-----");
                break;
            }
            case 2: {
                System.out.println("-----BEGIN CERTIFICATE-----");
            }
        }
        while ((string = bufferedReader2.readLine()) != null) {
            System.out.println(string);
        }
        switch (n) {
            case 1: {
                System.out.println("-----END CERTIFICATE REQUEST-----");
                break;
            }
            case 2: {
                System.out.println("-----END CERTIFICATE-----");
            }
        }
    }

    static {
        LoadProviders.init();
    }
}

