/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.LoadProviders;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.sslg.CertVerifyPolicyInt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class CertVerify {
    public static CertContext cctx = new CertContext();

    public static void loadRoots(String string) throws Exception {
        byte[] byArray;
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            cctx.addRoot(byArray);
        }
    }

    public static byte[] loadCert(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        byte[] byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null);
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        LoadProviders.init();
        boolean bl = false;
        CertVerifyPolicyInt certVerifyPolicyInt = new CertVerifyPolicyInt();
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            if (stringArray[n].equals("-debug")) {
                SSLDebug.setDebug(40);
                continue;
            }
            if (stringArray[n].equals("-damage")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-checkbc")) {
                certVerifyPolicyInt.requireBasicConstraints(true);
                continue;
            }
            if (stringArray[n].equals("-bccritical")) {
                certVerifyPolicyInt.requireBasicConstraintsCritical(true);
                continue;
            }
            if (stringArray[n].equals("-checkdates")) {
                certVerifyPolicyInt.checkDates(true);
                continue;
            }
            if (stringArray[n].equals("-checkkeyusage")) {
                certVerifyPolicyInt.requireKeyUsage(true);
                continue;
            }
            throw new InternalError("Bogus argument " + stringArray[n]);
        }
        CertVerify.loadRoots(stringArray[n++]);
        Vector<Object> vector = new Vector<Object>();
        while (n < stringArray.length) {
            byte[] byArray = CertVerify.loadCert(stringArray[n]);
            if (bl && n == stringArray.length - 1) {
                int n2 = byArray.length - 1;
                byArray[n2] = (byte)(byArray[n2] + 1);
            }
            object = new X509Cert(byArray);
            vector.addElement(object);
            ++n;
        }
        object = X509Cert.verifyCertChain(cctx, vector, certVerifyPolicyInt);
        if (object == null) {
            System.out.println("Couldn't verify chain");
        } else if (((Vector)object).size() == 1) {
            System.out.println("IS ROOT! Didn't actually verify signature");
        } else {
            System.out.println("Verified successfully");
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                X509Cert x509Cert = (X509Cert)((Vector)object).elementAt(i);
                System.out.println("Issuer " + x509Cert.getIssuerName().getNameString());
                System.out.println("Subject " + x509Cert.getSubjectName().getNameString());
                System.out.println("Serial " + x509Cert.getSerial());
                System.out.println("Validity " + x509Cert.getValidityNotBefore() + "-" + x509Cert.getValidityNotAfter());
            }
        }
    }
}

