/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DERUtils {
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte BIT_STRING = 3;
    public static final byte OCTET_STRING = 4;
    public static final byte OID = 6;
    public static final byte SET = 49;
    public static final byte SEQUENCE = 48;
    public static final byte IA5STRING = 22;
    public static final byte PRINTABLE_STRING = 19;
    public static final byte T61STRING = 20;
    public static final byte UTCTIME = 23;
    private static final int[] legals = new int[]{32, 39, 40, 41, 43, 44, 45, 46, 47, 58, 61, 63};

    private static void writeLength(int n, OutputStream outputStream) throws IOException {
        if (n < 128) {
            outputStream.write((byte)n);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 1;
            while (n > 0) {
                byteArrayOutputStream.write((byte)(n & 0xFF));
                n >>= 8;
                ++n2;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            outputStream.write((byte)(0x80 | byArray.length));
            for (n2 = 0; n2 < byArray.length; ++n2) {
                outputStream.write(byArray[byArray.length - (n2 + 1)]);
            }
        }
    }

    private static void encodeBytes(byte by, byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(by);
        DERUtils.writeLength(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void encodeInteger(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0 && byArray.length > 1 && (byArray[1] & 0x80) == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        DERUtils.encodeBytes((byte)2, byArray, outputStream);
    }

    public static void encodeSequence(byte[] byArray, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)48, byArray, outputStream);
    }

    public static void encodeSequence(ByteArrayOutputStream byteArrayOutputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DERUtils.encodeSequence(byArray, outputStream);
    }

    public static void encodeSet(byte[] byArray, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)49, byArray, outputStream);
    }

    public static void encodeSet(ByteArrayOutputStream byteArrayOutputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DERUtils.encodeSet(byArray, outputStream);
    }

    public static void encodeOID(byte[] byArray, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)6, byArray, outputStream);
    }

    private static void encodeBase128(int n, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[6];
        for (int i = 0; i < 6; ++i) {
            byArray[i] = (byte)(n & 0x7F);
            if ((n >>= 7) == 0) break;
        }
        for (int i = i; i >= 0; --i) {
            if (i == 0) {
                outputStream.write(byArray[i]);
                continue;
            }
            outputStream.write(byArray[i] | 0x80);
        }
    }

    public static void encodeOID(String string, OutputStream outputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
        }
        byteArrayOutputStream.write(nArray[0] * 40 + nArray[1]);
        for (n = 2; n < nArray.length; ++n) {
            DERUtils.encodeBase128(nArray[n], byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DERUtils.encodeOID(byArray, outputStream);
    }

    public static void encodeIA5String(String string, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)22, string.getBytes(), outputStream);
    }

    public static void encodePrintableString(String string, OutputStream outputStream) throws IOException {
        DERUtils.encodeBytes((byte)19, string.getBytes(), outputStream);
    }

    private static boolean isPrintableString(String string) {
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] >= 48 && byArray[i] <= 57 || byArray[i] >= 65 && byArray[i] <= 90 || byArray[i] >= 97 && byArray[i] <= 122) continue;
            for (int j = 0; j < legals.length; ++j) {
                if (byArray[i] != legals[j]) continue;
            }
            return false;
        }
        return true;
    }

    public static void encodeUnknownString(String string, OutputStream outputStream) throws IOException {
        if (DERUtils.isPrintableString(string)) {
            DERUtils.encodePrintableString(string, outputStream);
        } else {
            DERUtils.encodeIA5String(string, outputStream);
        }
    }

    public static void encodeBitString(byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(3);
        DERUtils.writeLength(byArray.length + 1, outputStream);
        outputStream.write(0);
        outputStream.write(byArray);
    }

    private static void put2digits(byte[] byArray, int n, int n2) {
        if (n > 99) {
            throw new InternalError("Illegal value");
        }
        if (n < 0) {
            throw new InternalError("Illegal value");
        }
        byArray[n2++] = (byte)(n / 10 + 48 & 0xFF);
        byArray[n2++] = (byte)(n % 10 + 48 & 0xFF);
    }

    public static void encodeUTCTime(long l, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[13];
        int n = 0;
        Date date = new Date(l);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(2);
        ++n3;
        int n4 = gregorianCalendar.get(5);
        int n5 = gregorianCalendar.get(11);
        int n6 = gregorianCalendar.get(12);
        int n7 = gregorianCalendar.get(13);
        if (n2 < 1950) {
            throw new InternalError("Bad time to encode " + gregorianCalendar.toString());
        }
        if (n2 > 2049) {
            throw new InternalError("Bad time to encode " + gregorianCalendar.toString());
        }
        n2 = n2 < 2000 ? (n2 -= 1900) : (n2 -= 2000);
        DERUtils.put2digits(byArray, n2, n);
        DERUtils.put2digits(byArray, n3, n += 2);
        DERUtils.put2digits(byArray, n4, n += 2);
        DERUtils.put2digits(byArray, n5, n += 2);
        DERUtils.put2digits(byArray, n6, n += 2);
        DERUtils.put2digits(byArray, n7, n += 2);
        byArray[n += 2] = 90;
        DERUtils.encodeBytes((byte)23, byArray, outputStream);
    }

    public static byte[] decodeSequence(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(48, inputStream);
    }

    public static byte[] decodeOID(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(6, inputStream);
    }

    public static byte[] decodeOctetString(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(4, inputStream);
    }

    public static BigInteger decodeInteger(InputStream inputStream) throws IOException {
        byte[] byArray = DERUtils.readTLV(2, inputStream);
        return new BigInteger(1, byArray);
    }

    public static int decodeIntegerX(InputStream inputStream) throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(0xFFFFFFFL);
        BigInteger bigInteger2 = DERUtils.decodeInteger(inputStream);
        if (bigInteger2.compareTo(bigInteger) > 0) {
            throw new IOException("Overlarge big integer");
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw new IOException("Tried to decode negative number");
        }
        return bigInteger2.intValue();
    }

    public static BitSet decodeBitStringX(InputStream inputStream) throws IOException {
        byte[] byArray = DERUtils.decodeBitString(inputStream);
        byte by = byArray[0];
        BitSet bitSet = new BitSet();
        for (int i = 1; i < byArray.length; ++i) {
            int n = i != byArray.length - 1 ? 8 : 8 - by;
            int n2 = 128;
            for (int j = 0; j < n; ++j) {
                int n3 = byArray[i] & 0xFF;
                if ((n2 & n3) == n2) {
                    bitSet.set((i - 1) * 8 + j);
                }
                n2 >>= 1;
            }
        }
        return bitSet;
    }

    public static byte[] decodeBitString(InputStream inputStream) throws IOException {
        return DERUtils.readTLV(3, inputStream);
    }

    public static boolean decodeBoolean(InputStream inputStream) throws IOException {
        byte[] byArray = DERUtils.readTLV(1, inputStream);
        if (byArray.length != 1) {
            throw new IOException("Bad encoding for boolean");
        }
        switch (byArray[0]) {
            case -1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IOException("Boolean must be either 0xff or 0");
    }

    public static byte[] decodeAny(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = DERUtils.decodeTag(inputStream);
        byte[] byArray = DERUtils.readLV(inputStream);
        DERUtils.encodeBytes((byte)n, byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] readTLV(int n, InputStream inputStream) throws IOException {
        DERUtils.decodeTagOrDie(n, inputStream);
        byte[] byArray = DERUtils.readLV(inputStream);
        return byArray;
    }

    private static byte[] readLV(InputStream inputStream) throws IOException {
        int n;
        int n2 = DERUtils.decodeLength(inputStream);
        byte[] byArray = new byte[n2];
        if (n2 != 0 && (n = inputStream.read(byArray)) != n2) {
            throw new IOException("Bad encoding: short read");
        }
        return byArray;
    }

    private static void decodeTagOrDie(int n, InputStream inputStream) throws IOException {
        if (!DERUtils.decodeTag(n, inputStream)) {
            throw new IOException("Bad encoding: wrong tag");
        }
    }

    private static int decodeTag(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        return n;
    }

    private static boolean decodeTag(int n, InputStream inputStream) throws IOException {
        int n2 = DERUtils.decodeTag(inputStream);
        if (n2 < 0) {
            return false;
        }
        return n2 == n;
    }

    public static boolean isTag(int n, InputStream inputStream) throws IOException {
        inputStream.mark(1);
        boolean bl = DERUtils.decodeTag(n, inputStream);
        inputStream.reset();
        return bl;
    }

    private static int decodeLength(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new IOException("Bad encoding: short read");
        }
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        int n3 = n2 & 0x7F;
        while (n3-- > 0) {
            n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Bad encoding: short read");
            }
            n *= 256;
            n += n2;
        }
        return n;
    }
}

