/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.X509Ext;
import COM.claymoresystems.ptls.SSLDebug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.BitSet;

class X509KeyUsage {
    static byte[] oid = new byte[]{85, 29, 15};
    static int BIT_digitalSignature = 0;
    static int BIT_nonRepudiation = 1;
    static int BIT_keyEncipherment = 2;
    static int BIT_dataEncipherment = 3;
    static int BIT_keyAgreement = 4;
    static int BIT_keyCertSign = 5;
    static int BIT_cRLSign = 6;
    static int BIT_encipherOnly = 7;
    static int BIT_decipherOnly = 8;
    private boolean critical;
    BitSet bitsAsserted = null;

    X509KeyUsage(X509Ext x509Ext) throws IOException {
        this.critical = x509Ext.isCritical();
        SSLDebug.debug(32, "Contents of keyUsage", x509Ext.getValue());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Ext.getValue());
        byte[] byArray = DERUtils.decodeOctetString(byteArrayInputStream);
        if (byteArrayInputStream.available() != 0) {
            throw new IOException("Overlong keyUsage encoding, bytes left=" + byteArrayInputStream.available());
        }
        SSLDebug.debug(32, "Sequence encoding", byArray);
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.bitsAsserted = DERUtils.decodeBitStringX(byteArrayInputStream);
        if (byteArrayInputStream.available() != 0) {
            throw new IOException("Overlong keyUsage encoding, bytes left=" + byteArrayInputStream.available());
        }
    }

    boolean isAsserted(int n) {
        return this.bitsAsserted.get(n);
    }
}

