/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.sslg.DistinguishedName;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParserVisitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class X509Name
implements DistinguishedName {
    private static String[][] OIDMAP = new String[][]{{"2.5.4.6", "C"}, {"2.5.4.8", "ST"}, {"2.5.4.7", "L"}, {"2.5.4.9", "STREET"}, {"2.5.4.10", "O"}, {"2.5.4.11", "OU"}, {"2.5.4.3", "CN"}, {"1.2.840.113549.1.9.1", "EmailAddress"}, {"2.5.4.5", "SN"}};
    private byte[] nameDER = null;
    private Vector name = null;
    private String nameString = null;

    public X509Name(byte[] byArray) {
        this.nameDER = byArray;
        this.name = X509Name.rawNameToName(byArray);
    }

    public X509Name(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Vector<String[]> vector3 = new Vector<String[]>();
            Vector vector4 = (Vector)vector.elementAt(i);
            for (int j = 0; j < vector4.size(); ++j) {
                String[] stringArray = new String[2];
                String[] stringArray2 = (String[])vector4.elementAt(j);
                stringArray[0] = new String(stringArray2[0]);
                stringArray[1] = new String(stringArray2[1]);
                vector3.addElement(stringArray);
            }
            vector2.addElement(vector3);
        }
        this.name = vector2;
    }

    public byte[] getNameDER() {
        try {
            if (this.nameDER == null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                for (int i = 0; i < this.name.size(); ++i) {
                    Vector vector = (Vector)this.name.elementAt(i);
                    this.encodeRDN(vector, byteArrayOutputStream);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream = new ByteArrayOutputStream();
                DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
                this.nameDER = byteArrayOutputStream.toByteArray();
            }
            return this.nameDER;
        }
        catch (IOException iOException) {
            throw new InternalError("Problem encoding: " + iOException.toString());
        }
    }

    private void encodeRDN(Vector vector, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < vector.size(); ++i) {
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            String[] stringArray = (String[])vector.elementAt(i);
            DERUtils.encodeOID(X509Name.lookupComponent(stringArray[0]), (OutputStream)byteArrayOutputStream2);
            DERUtils.encodeUnknownString(stringArray[1], byteArrayOutputStream2);
            DERUtils.encodeSequence(byteArrayOutputStream2, (OutputStream)byteArrayOutputStream);
        }
        DERUtils.encodeSet(byteArrayOutputStream, outputStream);
    }

    public Vector getName() {
        return this.name;
    }

    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.nameString == null) {
            for (int i = 0; i < this.name.size(); ++i) {
                Vector vector = (Vector)this.name.elementAt(i);
                if (i > 0) {
                    stringBuffer.append(",");
                }
                for (int j = 0; j < vector.size(); ++j) {
                    String[] stringArray = (String[])vector.elementAt(j);
                    if (j > 0) {
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(stringArray[0] + "=" + stringArray[1]);
                }
            }
            this.nameString = stringBuffer.toString();
        }
        return this.nameString;
    }

    private static String lookupOID(String string) {
        for (int i = 0; i < OIDMAP.length; ++i) {
            if (!string.equals(OIDMAP[i][0])) continue;
            return OIDMAP[i][1];
        }
        return "Unknown Attribute(" + string + ")";
    }

    private static String lookupComponent(String string) {
        for (int i = 0; i < OIDMAP.length; ++i) {
            if (!string.equals(OIDMAP[i][1])) continue;
            return OIDMAP[i][0];
        }
        throw new InternalError("Unknown component type " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector rawNameToName(byte[] byArray) {
        Vector vector = new Vector();
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            ASNObject aSNObject = CertContext.getSpec().getComponent("Name");
            CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init((InputStream)byteArrayInputStream);
            try {
                aSNObject.accept((ParserVisitor)coderOperations, null);
                Vector vector2 = (Vector)aSNObject.getValue();
                X509Name.vecDebug(vector2);
                for (int i = 0; i < vector2.size(); ++i) {
                    Vector vector3 = (Vector)vector2.elementAt(i);
                    X509Name.vecDebug(vector3);
                    Vector vector4 = (Vector)vector3.elementAt(0);
                    X509Name.vecDebug(vector4);
                    Vector<String[]> vector5 = new Vector<String[]>();
                    for (int j = 0; j < vector4.size(); ++j) {
                        Vector vector6 = (Vector)vector4.elementAt(j);
                        X509Name.vecDebug(vector6);
                        Vector vector7 = (Vector)vector6.elementAt(0);
                        X509Name.vecDebug(vector7);
                        Vector vector8 = (Vector)vector7.elementAt(0);
                        X509Name.vecDebug(vector8);
                        String string = (String)vector8.elementAt(0);
                        String string2 = (String)vector8.elementAt(1);
                        String[] stringArray = new String[]{X509Name.lookupOID(string), string2};
                        vector5.addElement(stringArray);
                    }
                    vector.addElement(vector5);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
                throw new InternalError(iOException.toString());
            }
        }
        return vector;
    }

    private static void vecDebug(Vector vector) {
    }
}

