/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertContext;
import COM.claymoresystems.cert.DERUtils;
import COM.claymoresystems.cert.X509SubjectPublicKeyInfo;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParserVisitor;
import cryptix.provider.rsa.BaseRSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import xjava.security.interfaces.CryptixRSAPublicKey;

class X509RSAPublicKey
extends BaseRSAPublicKey {
    private byte[] encoding;
    private byte[] oid = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509RSAPublicKey(String string, byte[] byArray, byte[] byArray2) throws IOException {
        this.encoding = byArray2;
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            SSLDebug.debug(8, "RSA Public key encoding", byArray2);
            if (byArray2[0] != 0) {
                throw new IOException("Bad encoded key");
            }
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
            CoderOperations coderOperations = BaseCoder.getInstance((String)"DER");
            coderOperations.init((InputStream)byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("RSAPublicKey");
            aSNObject.accept((ParserVisitor)coderOperations, null);
            BigInteger bigInteger = (BigInteger)aSNObject.getComponent("RSAPublicKey.modulus").getValue();
            BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("RSAPublicKey.publicExponent").getValue();
            SSLDebug.debug(32, "Modulus ", bigInteger.toByteArray());
            SSLDebug.debug(32, "Public ", bigInteger2.toByteArray());
            this.setRsaParams(bigInteger, bigInteger2);
        }
    }

    public X509RSAPublicKey(CryptixRSAPublicKey cryptixRSAPublicKey) {
        BaseRSAPublicKey baseRSAPublicKey = (BaseRSAPublicKey)cryptixRSAPublicKey;
        this.setRsaParams(baseRSAPublicKey.getModulus(), baseRSAPublicKey.getExponent());
    }

    public String getFormat() {
        return "PKCS-1";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.encoding != null) {
            return this.encoding;
        }
        try {
            DERUtils.encodeInteger(this.getModulus(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.getExponent(), byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byte[] byArray3 = new byte[]{};
            this.encoding = X509SubjectPublicKeyInfo.encodePublicKey(this.oid, byArray3, byArray2);
            return this.encoding;
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }
}

