/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.ptls.SSLDebug;
import COM.claymoresystems.util.RFC822Hdr;
import COM.claymoresystems.util.Util;
import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import java.util.Random;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

class PEMData {
    private static Hashtable eay2jce = null;
    private static Hashtable kSize = null;
    private static String encryptionAlg = "DES-EDE3-CBC";

    PEMData() {
    }

    static byte[] readPEMObject(BufferedReader bufferedReader, byte[] byArray) throws IOException {
        byte[] byArray2;
        RFC822Hdr rFC822Hdr = new RFC822Hdr(bufferedReader);
        RFC822Hdr rFC822Hdr2 = null;
        if (rFC822Hdr.getName() != null) {
            if (!rFC822Hdr.getSubfield(0).equals("4")) {
                throw new IOException("Unknown proc type" + rFC822Hdr.getSubfield(0));
            }
            rFC822Hdr2 = new RFC822Hdr(bufferedReader);
            try {
                byte[] byArray3 = WrappedObject.readBlock(bufferedReader);
                String string = rFC822Hdr2.getSubfield(0);
                String string2 = (String)eay2jce.get(string);
                if (string2 == null) {
                    throw new InternalError("Algorithm " + string + " not recognized");
                }
                byte[] byArray4 = new byte[((Integer)kSize.get(string)).intValue()];
                byte[] byArray5 = Hex.fromString((String)rFC822Hdr2.getSubfield(1));
                PEMData.EVP_BytesToKey("MD5", byArray5, byArray, (short)1, byArray4, null);
                RawSecretKey rawSecretKey = new RawSecretKey(string2, byArray4);
                Cipher cipher = Cipher.getInstance((String)string2);
                ((FeedbackCipher)cipher).setInitializationVector(byArray5);
                cipher.initDecrypt((Key)rawSecretKey);
                SSLDebug.debug(8, "PEM Data cipherText", byArray3);
                byArray2 = cipher.crypt(byArray3);
                SSLDebug.debug(8, "PEM Data plaintext", byArray2);
            }
            catch (KeyException keyException) {
                throw new InternalError(keyException.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError(noSuchAlgorithmException.toString());
            }
        } else {
            byArray2 = WrappedObject.readBlock(bufferedReader);
        }
        return byArray2;
    }

    static void writePEMObject(byte[] byArray, byte[] byArray2, String string, BufferedWriter bufferedWriter) throws IOException {
        byte[] byArray3;
        Object object;
        String string2;
        byte[] byArray4 = new byte[8];
        Random random = new Random();
        random.nextBytes(byArray4);
        try {
            string2 = (String)eay2jce.get(encryptionAlg);
            object = new byte[((Integer)kSize.get(encryptionAlg)).intValue()];
            PEMData.EVP_BytesToKey("MD5", byArray4, byArray2, (short)1, object, null);
            Cipher cipher = Cipher.getInstance((String)string2);
            ((FeedbackCipher)cipher).setInitializationVector(byArray4);
            RawSecretKey rawSecretKey = new RawSecretKey(string2, object);
            cipher.initEncrypt((Key)rawSecretKey);
            SSLDebug.debug(8, "Writing PEM Data plaintext", byArray);
            byArray3 = cipher.crypt(byArray);
            SSLDebug.debug(8, "Writing PEM Data cipherText", byArray3);
        }
        catch (KeyException keyException) {
            throw new InternalError(keyException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(noSuchAlgorithmException.toString());
        }
        string2 = "-----BEGIN " + string + "-----";
        bufferedWriter.write(string2);
        bufferedWriter.newLine();
        bufferedWriter.write("Proc-Type: 4,ENCRYPTED");
        bufferedWriter.newLine();
        object = "DEK-Info: " + encryptionAlg + "," + Hex.toString((byte[])byArray4);
        bufferedWriter.write((String)object);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        WrappedObject.writeObject(byArray3, string, bufferedWriter);
    }

    static void EVP_BytesToKey(String string, byte[] byArray, byte[] byArray2, short n, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = null;
        int n2 = 0;
        int n3 = byArray3.length;
        int n4 = 0;
        int n5 = 0;
        if (byArray4 != null) {
            n5 = byArray4.length;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            do {
                int n6;
                int n7;
                if (byArray5 != null) {
                    messageDigest.update(byArray5);
                }
                messageDigest.update(byArray2);
                if (byArray != null) {
                    messageDigest.update(byArray);
                }
                byArray5 = messageDigest.digest();
                for (n7 = 1; n7 < n; n7 = (int)((short)(n7 + 1))) {
                    messageDigest.update(byArray5);
                    byArray5 = messageDigest.digest();
                }
                n7 = byArray5.length;
                int n8 = 0;
                if (n3 != 0) {
                    n6 = Util.min(n3, n7);
                    System.arraycopy(byArray5, 0, byArray3, n2, n6);
                    n7 -= n6;
                    n8 = n6;
                    n3 -= n6;
                    n2 += n6;
                }
                if (n7 < 0 || n5 <= 0) continue;
                n6 = Util.min(n5, n7);
                System.arraycopy(byArray5, n8, byArray4, n4, n6);
                n5 -= n6;
                n4 += n6;
            } while (n3 != 0 || n5 != 0);
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
    }

    static {
        eay2jce = new Hashtable();
        eay2jce.put("DES-EDE3-CBC", "3DES/CBC/PKCS5Padding");
        eay2jce.put("DES-CBC", "DES/CBC/PKCS5Padding");
        kSize = new Hashtable();
        kSize.put("DES-EDE3-CBC", new Integer(24));
        kSize.put("DES-CBC", new Integer(8));
    }
}

