/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.crypto;

import COM.claymoresystems.crypto.PKCS1Pad;
import java.math.BigInteger;

class PKCS1PadTest {
    PKCS1PadTest() {
    }

    static void test(BigInteger bigInteger, byte[] byArray, boolean bl, String string) {
        byte[] byArray2 = null;
        String string2 = "OK";
        try {
            byArray2 = PKCS1Pad.pkcs1UnpadBuf(byArray, 2, bigInteger);
        }
        catch (Exception exception) {
            if (bl) {
                throw new InternalError("Should have succeeded");
            }
            string2 = exception.toString();
        }
        if (byArray2 != null && !bl) {
            throw new InternalError("Should have failed");
        }
        System.out.println("Test " + string + " " + string2 + "(PASS)");
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[128];
        for (int i = 0; i < 128; ++i) {
            byArray[i] = 0;
        }
        byArray[0] = -128;
        BigInteger bigInteger = new BigInteger(1, byArray);
        byte[] byArray2 = new byte[127];
        byArray2[0] = 1;
        for (int i = 1; i < 127; ++i) {
            byArray2[i] = -1;
        }
        PKCS1PadTest.test(bigInteger, byArray2, false, "No value");
        byArray2[65] = 0;
        PKCS1PadTest.test(bigInteger, byArray2, true, "Good");
        byArray2[64] = 55;
        PKCS1PadTest.test(bigInteger, byArray2, false, "Bad pad (not ff)");
        byArray2[7] = 0;
        PKCS1PadTest.test(bigInteger, byArray2, false, "Short pad");
        byArray2[0] = 2;
        PKCS1PadTest.test(bigInteger, byArray2, false, "Wrong block type pad");
        byte[] byArray3 = new byte[126];
        PKCS1PadTest.test(bigInteger, byArray3, false, "Short block");
    }
}

