/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider;

import COM.claymoresystems.crypto.Blindable;
import COM.claymoresystems.crypto.PKCS1Pad;
import COM.claymoresystems.provider.RSAAlgorithmBlind;
import cryptix.util.core.ArrayUtil;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public class RSASignature
extends Signature
implements Blindable {
    private byte[] data = null;
    private BigInteger n;
    private BigInteger exp;
    private BigInteger publicExp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private SecureRandom blindingRNG = null;

    public RSASignature() {
        super("RawRSAPKCS#1");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Public Key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)publicKey;
        this.n = cryptixRSAPublicKey.getModulus();
        this.exp = cryptixRSAPublicKey.getExponent();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Private Key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)privateKey;
        this.n = cryptixRSAPrivateKey.getModulus();
        this.exp = cryptixRSAPrivateKey.getExponent();
        if (privateKey instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)privateKey;
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a complete input");
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw RSA may only be updated once");
        }
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        byte[] byArray = PKCS1Pad.pkcs1PadBuf(this.data, this.n, 2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithmBlind.rsa(bigInteger, this.n, this.exp, this.publicExp, this.p, this.q, this.u, this.blindingRNG);
        byte[] byArray2 = this.sigToBytes(bigInteger2);
        return byArray2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        if (byArray.length != this.modLength()) {
            throw new IllegalBlockSizeException("Wrong input length");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (bigInteger.compareTo(this.n) > 0) {
            throw new IllegalBlockSizeException("Signature greater than modulus");
        }
        byte[] byArray2 = RSAAlgorithmBlind.rsa(bigInteger, this.n, this.exp, null, this.p, this.q, this.u, null).toByteArray();
        byte[] byArray3 = null;
        try {
            byArray3 = PKCS1Pad.pkcs1UnpadBuf(byArray2, 2, this.n);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            return false;
        }
        return ArrayUtil.areEqual((byte[])byArray3, (byte[])this.data);
    }

    public void setBlindingInfo(SecureRandom secureRandom, CryptixRSAPublicKey cryptixRSAPublicKey) {
        this.blindingRNG = secureRandom;
        this.publicExp = cryptixRSAPublicKey.getExponent();
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected byte[] sigToBytes(BigInteger bigInteger) {
        int n;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == (n = this.modLength())) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        if (byArray.length < n) {
            int n2;
            for (n2 = 0; n2 < n - byArray.length; ++n2) {
                byArray2[n2] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        } else {
            int n3;
            for (n3 = 0; n3 < byArray.length - n; ++n3) {
                if (byArray[n3] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(byArray, n3, byArray2, 0, n);
        }
        return byArray2;
    }

    private int modLength() {
        int n = this.n.bitLength() / 8;
        return n += this.n.bitLength() % 8 > 0 ? 1 : 0;
    }
}

