/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.provider.test;

import COM.claymoresystems.crypto.Blindable;
import COM.claymoresystems.provider.ClaymoreProvider;
import COM.claymoresystems.util.Bench;
import COM.claymoresystems.util.Util;
import cryptix.provider.Cryptix;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import xjava.security.Cipher;
import xjava.security.interfaces.CryptixRSAPublicKey;

class RSATest
extends Bench {
    private static final byte[] testString = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};

    RSATest() {
    }

    public static void main(String[] stringArray) throws NoSuchAlgorithmException {
        Object object;
        int n = 1;
        Security.addProvider((Provider)new Cryptix());
        Security.addProvider(new ClaymoreProvider());
        try {
            object = Cipher.getInstance((String)"RSABlind", (String)"Cryptix");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        if (stringArray.length != 0) {
            if (stringArray.length == 1) {
                n = Integer.parseInt(stringArray[0]);
            } else {
                throw new InternalError("Bad arguments");
            }
        }
        try {
            object = KeyPairGenerator.getInstance("RSA");
            ((KeyPairGenerator)object).initialize(1024, new SecureRandom());
            KeyPair keyPair = ((KeyPairGenerator)object).generateKeyPair();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(testString);
            PrivateKey privateKey = keyPair.getPrivate();
            CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)keyPair.getPublic();
            byte[] byArray = messageDigest.digest();
            for (int i = 0; i < n; ++i) {
                Signature signature = Signature.getInstance("RawRSA");
                Signature signature2 = Signature.getInstance("RawRSA");
                signature.initSign(privateKey);
                ((Blindable)((Object)signature)).setBlindingInfo(new SecureRandom(), cryptixRSAPublicKey);
                signature.update(byArray);
                byte[] byArray2 = signature.sign();
                Util.xdump("signature", byArray2);
                PublicKey publicKey = keyPair.getPublic();
                signature2.initVerify(publicKey);
                signature2.update(byArray);
                boolean bl = signature2.verify(byArray2);
                if (bl) {
                    System.out.println("Verifies with our implementation");
                } else {
                    System.out.println("Failed our verify. (WRONG!)");
                }
                signature2 = Signature.getInstance("RawRSA");
                byArray[0] = (byte)(byArray[0] + 1);
                signature2.initVerify(publicKey);
                signature2.update(byArray);
                bl = signature2.verify(byArray2);
                if (bl) {
                    System.out.println("Bad signature verifies (WRONG!)");
                    continue;
                }
                System.out.println("Bad signature doesn't verify (OK)");
            }
        }
        catch (Exception exception) {
            System.err.println("Caught exception " + exception.toString());
            exception.printStackTrace(System.out);
        }
        RSATest.dump();
    }
}

