/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLConn;
import COM.claymoresystems.ptls.SSLPDU;
import COM.claymoresystems.ptls.SSLopaque;
import COM.claymoresystems.ptls.SSLuint8;
import COM.claymoresystems.ptls.SSLvector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

class SSLCertificateRequest
extends SSLPDU {
    SSLvector certificate_types = new SSLvector(-255, new SSLuint8());
    SSLvector distinguished_names = new SSLvector(-65535, new SSLopaque(-65535));

    SSLCertificateRequest() {
    }

    public int encode(SSLConn sSLConn, OutputStream outputStream) throws IOException {
        SSLuint8 sSLuint8 = new SSLuint8(2);
        SSLuint8 sSLuint82 = new SSLuint8(1);
        this.certificate_types.value.addElement(sSLuint82);
        this.certificate_types.value.addElement(sSLuint8);
        Vector vector = sSLConn.hs.cert_ctx.getRootList();
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray = ((X509Cert)vector.elementAt(i)).getSubjectDER();
            SSLopaque sSLopaque = new SSLopaque(-65535);
            sSLopaque.value = byArray;
            this.distinguished_names.value.addElement(sSLopaque);
        }
        int n = this.certificate_types.encode(sSLConn, outputStream);
        return n += this.distinguished_names.encode(sSLConn, outputStream);
    }

    public int decode(SSLConn sSLConn, InputStream inputStream) throws IOException {
        int n = this.certificate_types.decode(sSLConn, inputStream);
        return n += this.distinguished_names.decode(sSLConn, inputStream);
    }
}

