/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.ptls;

import COM.claymoresystems.crypto.DHPrivateKey;
import COM.claymoresystems.crypto.DHPublicKey;
import COM.claymoresystems.ptls.SSLDebug;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SSLDHPrivateKey
extends DHPrivateKey {
    private SecureRandom rand;
    private static int PRIME_CERTAINTY = 80;

    public void initPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        this.g = bigInteger;
        this.p = bigInteger2;
        this.rand = secureRandom;
        this.generatePrivate();
    }

    public void initPrivateKey(SecureRandom secureRandom, int n, boolean bl) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = new BigInteger("24");
        BigInteger bigInteger5 = new BigInteger("11");
        BigInteger bigInteger6 = new BigInteger("0");
        if (n % 8 != 0) {
            throw new InternalError("keylength must be a multiple of 8");
        }
        if (n < 768) {
            throw new InternalError("Keylength must be minimum 768");
        }
        int n2 = n / 8;
        byte[] byArray = new byte[n2];
        if (bl) {
            secureRandom.nextBytes(byArray);
            for (int i = 0; i < 8; ++i) {
                byArray[i] = -1;
                byArray[n2 - (i + 1)] = -1;
            }
            bigInteger = new BigInteger("0");
            bigInteger3 = bigInteger.setBit(64);
            bigInteger2 = new BigInteger(1, byArray);
        }
        this.g = new BigInteger("2");
        while (true) {
            if (bl) {
                bigInteger = bigInteger2.add(bigInteger3);
                if (!(bigInteger2 = bigInteger).isProbablePrime(2)) continue;
                SSLDebug.debug(8, "p passes quick check");
                BigInteger bigInteger7 = bigInteger2.shiftRight(1);
                if (!bigInteger7.isProbablePrime(PRIME_CERTAINTY)) continue;
                SSLDebug.debug(8, "q is prime");
            } else {
                secureRandom.nextBytes(byArray);
                byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
                int n3 = n2 - 1;
                byArray[n3] = (byte)(byArray[n3] | 1);
                bigInteger2 = new BigInteger(1, byArray);
                BigInteger bigInteger8 = bigInteger2.mod(bigInteger4);
                BigInteger bigInteger9 = bigInteger2.subtract(bigInteger8);
                bigInteger2 = bigInteger5.add(bigInteger9);
            }
            SSLDebug.debug(8, "p candidate", bigInteger2.toByteArray());
            if (bigInteger2.isProbablePrime(PRIME_CERTAINTY)) break;
            SSLDebug.debug(8, "p not prime");
        }
        this.rand = secureRandom;
        this.p = bigInteger2;
        bigInteger = this.p.mod(bigInteger4);
        SSLDebug.debug(8, "P is prime" + this.p.isProbablePrime(PRIME_CERTAINTY) + "mod 24=" + bigInteger);
        SSLDebug.debug(8, "p", this.p.toByteArray());
        this.generatePrivate();
    }

    public byte[] keyAgree(DHPublicKey dHPublicKey, boolean bl) {
        if (bl) {
            BigInteger bigInteger = dHPublicKey.getp();
            BigInteger bigInteger2 = dHPublicKey.getg();
            if (bigInteger2 != null || bigInteger != null) {
                if (this.g.compareTo(bigInteger2) != 0) {
                    throw new Error("DH parameters don't match (g)");
                }
                if (this.p.compareTo(bigInteger) != 0) {
                    throw new Error("DH parameters don't match (p)");
                }
            }
        }
        BigInteger bigInteger = dHPublicKey.getY();
        return this.toBytes(bigInteger.modPow(this.X, this.p));
    }

    private void generatePrivate() {
        int n = this.p.bitLength();
        int n2 = n / 8;
        int n3 = n % 8;
        if (n3 > 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        this.rand.nextBytes(byArray);
        int n4 = n3 > 0 ? 8 - n3 : 1;
        byArray[0] = (byte)(byArray[0] & (byte)(255 >> n4));
        this.X = new BigInteger(1, byArray);
        SSLDebug.debug(8, "DH private", byArray);
        this.Y = this.g.modPow(this.X, this.p);
    }
}

