/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.key;

import cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private static final String FORMAT = "RAW";
    private String algorithm;
    private byte[] data;

    public RawKey(String string, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = (byte[])byArray.clone();
    }

    public RawKey(String string, byte[] byArray, int n, int n2) {
        if (string == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.algorithm = string;
        this.data = new byte[n2];
        System.arraycopy(byArray, n, this.data, 0, n2);
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.data.length; n += 4) {
            n2 ^= this.data[n];
        }
        n2 <<= 8;
        for (n = 1; n < this.data.length; n += 4) {
            n2 ^= this.data[n];
        }
        n2 <<= 8;
        for (n = 2; n < this.data.length; n += 4) {
            n2 ^= this.data[n];
        }
        n2 <<= 8;
        for (n = 3; n < this.data.length; n += 4) {
            n2 ^= this.data[n];
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof RawKey) {
            return ArrayUtil.areEqual(this.data, ((RawKey)object).data);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return FORMAT;
    }

    public byte[] getEncoded() {
        return (byte[])this.data.clone();
    }
}

