/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.BlockMessageDigest;
import cryptix.util.core.Debug;
import java.io.PrintWriter;

public final class SHA0
extends BlockMessageDigest
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel("SHA-0");
    private static final PrintWriter err = Debug.getOutput();
    public static final int HASH_LENGTH = 20;
    public static final int DATA_LENGTH = 64;
    private int[] data;
    private int[] digest;
    private byte[] tmp;
    private int[] w;
    private static String[] texts = new String[]{"", "abc", "message digest"};
    private static byte[][] hashs = new byte[][]{{-7, 108, -22, 25, -118, -47, -35, 86, 23, -84, 8, 74, 61, -110, -58, 16, 119, 8, -64, -17}, {1, 100, -72, -87, 20, -51, 42, 94, 116, -60, -9, -1, 8, 44, 77, -105, -15, -19, -8, -128}, {-63, -80, -14, 34, -47, 80, -21, -71, -86, 54, -92, 12, -81, -36, -117, -53, -19, -125, 11, 20}};

    private static void debug(String string) {
        err.println("SHA-0: " + string);
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    protected int engineGetDataLength() {
        return 64;
    }

    public SHA0() {
        super("SHA-0");
        this.java_init();
        this.reset();
    }

    private void java_init() {
        this.digest = new int[5];
        this.data = new int[16];
        this.tmp = new byte[64];
        this.w = new int[80];
    }

    private SHA0(SHA0 sHA0) {
        this();
        this.data = (int[])sHA0.data.clone();
        this.digest = (int[])sHA0.digest.clone();
        this.tmp = (byte[])sHA0.tmp.clone();
        this.w = (int[])sHA0.w.clone();
    }

    public Object clone() {
        return new SHA0(this);
    }

    protected void engineReset() {
        super.engineReset();
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
    }

    protected void engineTransform(byte[] byArray) {
        this.java_transform(byArray);
    }

    private void java_transform(byte[] byArray) {
        SHA0.byte2int(byArray, 0, this.data, 0, 16);
        this.transform(this.data);
    }

    protected byte[] engineDigest(byte[] byArray, int n) {
        byte[] byArray2 = this.java_digest(byArray, n);
        this.engineReset();
        return byArray2;
    }

    private byte[] java_digest(byte[] byArray, int n) {
        if (n != 0) {
            System.arraycopy(byArray, 0, this.tmp, 0, n);
        }
        this.tmp[n++] = -128;
        if (n > 56) {
            while (n < 64) {
                this.tmp[n++] = 0;
            }
            SHA0.byte2int(this.tmp, 0, this.data, 0, 16);
            this.transform(this.data);
            n = 0;
        }
        while (n < 56) {
            this.tmp[n++] = 0;
        }
        SHA0.byte2int(this.tmp, 0, this.data, 0, 14);
        long l = this.bitcount();
        this.data[14] = (int)(l >>> 32);
        this.data[15] = (int)l;
        this.transform(this.data);
        byte[] byArray2 = new byte[20];
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            int n3 = this.digest[i];
            byArray2[n2++] = (byte)(n3 >>> 24);
            byArray2[n2++] = (byte)(n3 >>> 16);
            byArray2[n2++] = (byte)(n3 >>> 8);
            byArray2[n2++] = (byte)n3;
        }
        return byArray2;
    }

    private static int f1(int n, int n2, int n3) {
        return (n3 ^ n & (n2 ^ n3)) + 1518500249;
    }

    private static int f2(int n, int n2, int n3) {
        return (n ^ n2 ^ n3) + 1859775393;
    }

    private static int f3(int n, int n2, int n3) {
        return (n & n2 | n3 & (n | n2)) + -1894007588;
    }

    private static int f4(int n, int n2, int n3) {
        return (n ^ n2 ^ n3) + -899497514;
    }

    private void transform(int[] nArray) {
        int n;
        int n2 = this.digest[0];
        int n3 = this.digest[1];
        int n4 = this.digest[2];
        int n5 = this.digest[3];
        int n6 = this.digest[4];
        int[] nArray2 = this.w;
        for (n = 0; n < 16; ++n) {
            nArray2[n] = nArray[n];
        }
        for (n = 16; n < 80; ++n) {
            int n7;
            nArray2[n] = n7 = nArray2[n - 16] ^ nArray2[n - 14] ^ nArray2[n - 8] ^ nArray2[n - 3];
        }
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f1(n3, n4, n5) + nArray2[0];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f1(n2, n3, n4) + nArray2[1];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f1(n6, n2, n3) + nArray2[2];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f1(n5, n6, n2) + nArray2[3];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f1(n4, n5, n6) + nArray2[4];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f1(n3, n4, n5) + nArray2[5];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f1(n2, n3, n4) + nArray2[6];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f1(n6, n2, n3) + nArray2[7];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f1(n5, n6, n2) + nArray2[8];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f1(n4, n5, n6) + nArray2[9];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f1(n3, n4, n5) + nArray2[10];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f1(n2, n3, n4) + nArray2[11];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f1(n6, n2, n3) + nArray2[12];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f1(n5, n6, n2) + nArray2[13];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f1(n4, n5, n6) + nArray2[14];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f1(n3, n4, n5) + nArray2[15];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f1(n2, n3, n4) + nArray2[16];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f1(n6, n2, n3) + nArray2[17];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f1(n5, n6, n2) + nArray2[18];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f1(n4, n5, n6) + nArray2[19];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f2(n3, n4, n5) + nArray2[20];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f2(n2, n3, n4) + nArray2[21];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f2(n6, n2, n3) + nArray2[22];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f2(n5, n6, n2) + nArray2[23];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f2(n4, n5, n6) + nArray2[24];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f2(n3, n4, n5) + nArray2[25];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f2(n2, n3, n4) + nArray2[26];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f2(n6, n2, n3) + nArray2[27];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f2(n5, n6, n2) + nArray2[28];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f2(n4, n5, n6) + nArray2[29];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f2(n3, n4, n5) + nArray2[30];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f2(n2, n3, n4) + nArray2[31];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f2(n6, n2, n3) + nArray2[32];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f2(n5, n6, n2) + nArray2[33];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f2(n4, n5, n6) + nArray2[34];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f2(n3, n4, n5) + nArray2[35];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f2(n2, n3, n4) + nArray2[36];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f2(n6, n2, n3) + nArray2[37];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f2(n5, n6, n2) + nArray2[38];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f2(n4, n5, n6) + nArray2[39];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f3(n3, n4, n5) + nArray2[40];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f3(n2, n3, n4) + nArray2[41];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f3(n6, n2, n3) + nArray2[42];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f3(n5, n6, n2) + nArray2[43];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f3(n4, n5, n6) + nArray2[44];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f3(n3, n4, n5) + nArray2[45];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f3(n2, n3, n4) + nArray2[46];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f3(n6, n2, n3) + nArray2[47];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f3(n5, n6, n2) + nArray2[48];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f3(n4, n5, n6) + nArray2[49];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f3(n3, n4, n5) + nArray2[50];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f3(n2, n3, n4) + nArray2[51];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f3(n6, n2, n3) + nArray2[52];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f3(n5, n6, n2) + nArray2[53];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f3(n4, n5, n6) + nArray2[54];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f3(n3, n4, n5) + nArray2[55];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f3(n2, n3, n4) + nArray2[56];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f3(n6, n2, n3) + nArray2[57];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f3(n5, n6, n2) + nArray2[58];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f3(n4, n5, n6) + nArray2[59];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f4(n3, n4, n5) + nArray2[60];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f4(n2, n3, n4) + nArray2[61];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f4(n6, n2, n3) + nArray2[62];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f4(n5, n6, n2) + nArray2[63];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f4(n4, n5, n6) + nArray2[64];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f4(n3, n4, n5) + nArray2[65];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f4(n2, n3, n4) + nArray2[66];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f4(n6, n2, n3) + nArray2[67];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f4(n5, n6, n2) + nArray2[68];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f4(n4, n5, n6) + nArray2[69];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f4(n3, n4, n5) + nArray2[70];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f4(n2, n3, n4) + nArray2[71];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f4(n6, n2, n3) + nArray2[72];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f4(n5, n6, n2) + nArray2[73];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f4(n4, n5, n6) + nArray2[74];
        n4 = n4 << 30 | n4 >>> -30;
        n6 += (n2 << 5 | n2 >>> -5) + SHA0.f4(n3, n4, n5) + nArray2[75];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n6 << 5 | n6 >>> -5) + SHA0.f4(n2, n3, n4) + nArray2[76];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA0.f4(n6, n2, n3) + nArray2[77];
        n6 = n6 << 30 | n6 >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA0.f4(n5, n6, n2) + nArray2[78];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA0.f4(n4, n5, n6) + nArray2[79];
        n4 = n4 << 30 | n4 >>> -30;
        this.digest[0] = this.digest[0] + n2;
        this.digest[1] = this.digest[1] + n3;
        this.digest[2] = this.digest[2] + n4;
        this.digest[3] = this.digest[3] + n5;
        this.digest[4] = this.digest[4] + n6;
    }

    private static void byte2int(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        while (n3-- > 0) {
            nArray[n2++] = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            SHA0.self_test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static final void self_test() throws Exception {
        int n = hashs[0].length;
        for (int i = 0; i < texts.length; ++i) {
            SHA0 sHA0 = new SHA0();
            byte[] byArray = texts[i].getBytes();
            for (int j = 0; j < texts[i].length(); ++j) {
                sHA0.engineUpdate(byArray[j]);
            }
            if (!SHA0.notEquals(sHA0.engineDigest(), hashs[i])) continue;
            throw new Exception("hash #" + i + " failed");
        }
    }

    private static final boolean notEquals(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return true;
        }
        return false;
    }
}

