/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.mode;

import cryptix.CryptixException;
import cryptix.provider.mode.FeedbackMode;
import cryptix.util.core.ArrayUtil;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.Cipher;

public class PCBC
extends FeedbackMode {
    private byte[] xorBlock;

    public PCBC() {
        super(false, false, "Cryptix");
    }

    public PCBC(Cipher cipher) {
        this();
        this.engineSetCipher(cipher);
    }

    public PCBC(Cipher cipher, byte[] byArray) {
        this(cipher);
        this.setInitializationVector(byArray);
    }

    protected void engineSetCipher(Cipher cipher) {
        super.engineSetCipher(cipher);
        this.xorBlock = new byte[this.length];
    }

    protected int engineBlockSize() {
        return this.length;
    }

    protected void engineInitEncrypt(Key key) throws KeyException {
        this.cipher.initEncrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.xorBlock);
    }

    protected void engineInitDecrypt(Key key) throws KeyException {
        this.cipher.initDecrypt(key);
        if (this.ivStart != null) {
            System.arraycopy(this.ivStart, 0, this.ivBlock, 0, this.length);
        }
        ArrayUtil.clear(this.xorBlock);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.ivBlock == null) {
            throw new InvalidParameterException("PCBC: IV is not set");
        }
        if (n2 <= 0) {
            return 0;
        }
        switch (this.getState()) {
            case 1: {
                for (int i = 0; i < this.length; ++i) {
                    int n4 = i;
                    this.ivBlock[n4] = (byte)(this.ivBlock[n4] ^ byArray[n + i]);
                    int n5 = i;
                    this.xorBlock[n5] = (byte)(this.xorBlock[n5] ^ this.ivBlock[i]);
                }
                this.cipher.update(this.xorBlock, 0, this.length, this.ivBlock, 0);
                System.arraycopy(this.ivBlock, 0, byArray2, n3, this.length);
                System.arraycopy(byArray, n, this.xorBlock, 0, this.length);
                break;
            }
            case 2: {
                this.cipher.update(byArray, n, this.length, this.xorBlock, 0);
                for (int i = 0; i < this.length; ++i) {
                    byArray2[n3 + i] = (byte)(this.ivBlock[i] ^ this.xorBlock[i]);
                    this.ivBlock[i] = (byte)(byArray[n + i] ^ byArray2[n3 + i]);
                }
                break;
            }
            default: {
                throw new CryptixException("PCBC: Cipher not initialized");
            }
        }
        return this.length;
    }
}

