/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.provider.rsa.BaseRSAPrivateKey;
import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;

public class RawRSAPrivateKey
extends BaseRSAPrivateKey {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "RawRSAPrivateKey");
    private static final PrintWriter err = Debug.getOutput();

    private static void debug(String string) {
        err.println("RawRSAPrivateKey: " + string);
    }

    public RawRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setRsaParams(bigInteger, bigInteger2);
    }

    public RawRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, null);
    }

    public RawRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public RawRSAPrivateKey(InputStream inputStream) throws IOException {
        BigInteger bigInteger = BI.fromStream(inputStream);
        BigInteger bigInteger2 = BI.fromStream(inputStream);
        BigInteger bigInteger3 = BI.fromStream(inputStream);
        BigInteger bigInteger4 = BI.fromStream(inputStream);
        this.setRsaParams(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        try {
            BI.toStream(this.getExponent(), bufferedOutputStream);
            BI.toStream(this.getP(), bufferedOutputStream);
            BI.toStream(this.getQ(), bufferedOutputStream);
            BI.toStream(this.getInverseOfQModP(), bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

