/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import cryptix.util.test.BaseTest;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;

class TestIDEA
extends BaseTest {
    private static final String[][] testData1 = new String[][]{{"00010002000300040005000600070008", "0000000100020003", "11FBED2B01986DE5"}, {"00010002000300040005000600070008", "0102030405060708", "540E5FEA18C2F8B1"}, {"00010002000300040005000600070008", "0019324B647D96AF", "9F0A0AB6E10CED78"}, {"00010002000300040005000600070008", "F5202D5B9C671B08", "CF18FD7355E2C5C5"}, {"00010002000300040005000600070008", "FAE6D2BEAA96826E", "85DF52005608193D"}, {"00010002000300040005000600070008", "0A141E28323C4650", "2F7DE750212FB734"}, {"00010002000300040005000600070008", "050A0F14191E2328", "7B7314925DE59C09"}, {"0005000A000F00140019001E00230028", "0102030405060708", "3EC04780BEFF6E20"}, {"3A984E2000195DB32EE501C8C47CEA60", "0102030405060708", "97BCD8200780DA86"}, {"006400C8012C019001F4025802BC0320", "05320A6414C819FA", "65BE87E7A2538AED"}, {"9D4075C103BC322AFB03E7BE6AB30006", "0808080808080808", "F5DB1AC45E5EF9F9"}};
    private static final String[][] testData2 = new String[][]{{"00010002000300040005000600070008", "0000000100020003"}, {"00010002000300040005000600070008", "01020304050607084E"}, {"00010002000300040005000600070008", "0019324B647D96AF4E2019"}, {"00010002000300040005000600070008", "F5202D5B9C671B084E2009"}, {"00010002000300040005000600070008", "FAE6D2BEAA96826E4E200019"}, {"00010002000300040005000600070008", "0A141E28323C46504E200019"}, {"00010002000300040005000600070008", "050A0F14191E23284E2019"}, {"0005000A000F00140019001E00230028", "01020304050607080A000F"}, {"3A984E2000195DB32EE501C8C47CEA60", "0102030405060708EA60"}, {"006400C8012C019001F4025802BC0320", "05320A6414C819FA025802BC0320"}, {"9D4075C103BC322AFB03E7BE6AB30006", "08080808080808086AB30006"}};

    TestIDEA() {
    }

    public static void main(String[] stringArray) {
        new TestIDEA().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(66);
        this.out.println("*** IDEA in ECB mode:\n");
        Cipher cipher = Cipher.getInstance("IDEA", "Cryptix");
        this.test1(cipher, testData1);
        this.out.println("\n*** IDEA in CFB mode:\n");
        cipher = Cipher.getInstance("IDEA/CFB", "Cryptix");
        this.test2(cipher, testData2);
        this.out.println("\n*** IDEA in OFB mode:\n");
        cipher = Cipher.getInstance("IDEA/OFB", "Cryptix");
        this.test2(cipher, testData2);
        this.out.println("\n*** IDEA in CFB-PGP mode:\n");
        cipher = Cipher.getInstance("IDEA/CFB-PGP", "Cryptix");
        this.test2(cipher, testData2);
        this.out.println("\n*** IDEA in CBC mode with PKCS#5 padding:\n");
        cipher = Cipher.getInstance("IDEA/CBC/PKCS#5", "Cryptix");
        this.test2(cipher, testData2);
    }

    private void test1(Cipher cipher, String[][] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", Hex.fromString(stringArray[i][0]));
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray = cipher.crypt(Hex.fromString(stringArray[i][1]));
            String string = Hex.toString(byArray);
            cipher.initDecrypt(rawSecretKey);
            byte[] byArray2 = cipher.crypt(byArray);
            String string2 = Hex.toString(byArray2);
            this.out.println("\nplain:" + stringArray[i][1] + " enc:" + string + " calc:" + stringArray[i][2]);
            this.passIf(string.equals(stringArray[i][2]), "IDEA encrypt");
            this.out.println("  enc:" + Hex.toString(byArray) + " dec:" + string2 + " calc:" + stringArray[i][1]);
            this.passIf(string2.equals(stringArray[i][1]), "IDEA decrypt");
        }
    }

    private void test2(Cipher cipher, String[][] stringArray) throws Exception {
        byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ((FeedbackCipher)((Object)cipher)).setInitializationVector(byArray);
        for (int i = 0; i < stringArray.length; ++i) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", Hex.fromString(stringArray[i][0]));
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray2 = Hex.fromString(stringArray[i][1]);
            byte[] byArray3 = cipher.crypt(byArray2);
            cipher.initDecrypt(rawSecretKey);
            byte[] byArray4 = cipher.crypt(byArray3);
            this.out.println("\nplain:" + Hex.toString(byArray2) + " enc:" + Hex.toString(byArray3) + " dec:" + Hex.toString(byArray4));
            this.passIf(ArrayUtil.areEqual(byArray2, byArray4), "IDEA feedback");
        }
    }
}

