/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.tools.Scar;
import cryptix.util.test.BaseTest;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class TestScar
extends BaseTest {
    public static boolean DEBUG = false;
    public static final String tmpArch = "tmpARCH.scar";
    public static final String tmpDirS_in = "scarIN.tmp";
    public static final String tmpDirS_out = "scarOUT.tmp";
    public static final String tFile_1 = "file_1";
    public static final String tFile_2 = "file_2";
    public static final String tFile_3 = "file_3";
    public static final String testData_1 = "Marry had a little lamb";
    public static final String testData_2 = "Burp!, pardon me...";
    public static final char[] testData_3 = new char[]{'\u0001', '\u0002', '\u00f3', '\u00f4'};
    public static final String[] inParams = new String[]{"-er", "-p", "blabla", "scarIN.tmp", "tmpARCH.scar"};
    public static final String[] outParams = new String[]{"-d", "-p", "blabla", "tmpARCH.scar", "scarOUT.tmp"};

    public void localWriter(File file, Object object) throws IOException {
        String string;
        FileWriter fileWriter = new FileWriter(file);
        Class<?> clazz = object.getClass();
        String string2 = string = clazz.getComponentType() == null ? null : clazz.getComponentType().toString();
        if (DEBUG) {
            this.out.print("TestScar.localWriter(file, ");
            if (string == null) {
                this.out.println(clazz.getName() + ")");
            } else {
                this.out.println(string + "[])");
            }
        }
        if (object instanceof String) {
            fileWriter.write((String)object);
        } else if (string.equals("char")) {
            fileWriter.write((char[])object);
        } else {
            fileWriter.write(">> Unknown data of " + string + "[] type given as input <<");
        }
        fileWriter.flush();
        fileWriter.close();
    }

    public String localReader(File file) throws IOException {
        int n;
        FileReader fileReader = new FileReader(file);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = fileReader.read()) > -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    protected void engineTest() throws Exception {
        File file = new File(tmpDirS_in);
        File file2 = new File(tmpDirS_in, tFile_1);
        File file3 = new File(tmpDirS_in, tFile_2);
        File file4 = new File(tmpDirS_in, tFile_3);
        this.setExpectedPasses(3);
        try {
            if (file.mkdirs() && DEBUG) {
                this.out.println("\nDirectory scarIN.tmp created.");
            }
            this.localWriter(file2, testData_1);
            this.localWriter(file3, testData_2);
            this.localWriter(file4, testData_3);
        }
        catch (Exception exception) {
            this.error("Can't write test files: " + exception.getMessage());
            System.exit(1);
        }
        if (DEBUG) {
            this.out.println("TestScar> Starting Scar()");
        }
        Scar.DEBUG = false;
        Scar scar = new Scar();
        scar.processOptions(inParams);
        scar.run();
        if (DEBUG) {
            this.out.println("Encrypted. Now decrypting...");
        }
        if (file2.delete() && file3.delete() && file4.delete() && file.delete()) {
            if (DEBUG) {
                this.out.println("TestScar> Test files deleted.");
            }
        } else {
            System.err.println("TestScar> Warning: Unable to delete all test files!");
        }
        file = new File(tmpDirS_out);
        file2 = new File(tmpDirS_out, tFile_1);
        file3 = new File(tmpDirS_out, tFile_2);
        file4 = new File(tmpDirS_out, tFile_3);
        if (file.mkdirs() && DEBUG) {
            this.out.println("Directory scarOUT.tmp created.");
        }
        scar = new Scar();
        scar.processOptions(outParams);
        scar.run();
        this.passIf(this.localReader(file2).equals(testData_1), "Scar file 1 OK");
        this.passIf(this.localReader(file3).equals(testData_2), "Scar file 2 OK");
        this.passIf(this.localReader(file4).equals(new String(testData_3)), "Scar file 3 OK");
        if (file2.delete() && file3.delete() && file4.delete() && file.delete() && new File(tmpArch).delete()) {
            if (DEBUG) {
                this.out.println("TestScar> Test files deleted.");
            }
        } else {
            System.err.println("TestScar> Warning: Unable to delete all test files!");
        }
    }

    public static void main(String[] stringArray) {
        new TestScar().commandline(stringArray);
    }
}

