/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.io;

import cryptix.util.core.Debug;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;

public class DosFilter
implements FilenameFilter {
    private static final boolean DEBUG = true;
    private static int debuglevel = Debug.getLevel("DosFilter");
    private static final PrintWriter err = Debug.getOutput();
    private char[] nameMask;
    private char[] extMask;

    private static void debug(String string) {
        err.println("DosFilter: " + string);
    }

    public DosFilter() {
        this.reset();
    }

    public DosFilter(String string) {
        this.setMask(string);
    }

    public boolean accept(File file, String string) {
        char c;
        if (new File(file, string).isDirectory()) {
            return true;
        }
        if (debuglevel >= 3) {
            DosFilter.debug("filtering " + file.getAbsolutePath() + File.separator + string);
        }
        char[] cArray = null;
        char[] cArray2 = null;
        int n = string.indexOf(".");
        if (n == -1) {
            if (this.extMask != null) {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " FAILED 1\n");
                }
                return false;
            }
            cArray = string.toCharArray();
        } else {
            cArray = string.substring(0, n).toCharArray();
            cArray2 = string.substring(n + 1).toCharArray();
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (this.nameMask != null && n2 < cArray.length) {
            c = this.nameMask[n3];
            if (c == '*') {
                n2 = cArray.length;
                n3 = this.nameMask.length;
                continue;
            }
            if (c != '?' && c != cArray[n2]) {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " FAILED 2\n");
                }
                return false;
            }
            if (++n3 != this.nameMask.length || ++n2 >= cArray.length) continue;
            if (debuglevel >= 4) {
                DosFilter.debug(string + " FAILED 3\n");
            }
            return false;
        }
        bl = false;
        n2 = 0;
        n3 = 0;
        while (this.extMask != null && n2 < cArray2.length) {
            c = this.extMask[n3];
            if (c == '*') {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " OK 1\n");
                }
                return true;
            }
            if (c != '?' && c != cArray2[n2]) {
                if (debuglevel >= 4) {
                    DosFilter.debug(string + " FAILED 4\n");
                }
                return false;
            }
            if (++n3 != this.extMask.length || ++n2 >= cArray2.length) continue;
            if (debuglevel >= 4) {
                DosFilter.debug(string + " FAILED 5\n");
            }
            return false;
        }
        if (debuglevel >= 4) {
            DosFilter.debug(string + " OK 2\n");
        }
        return true;
    }

    public void reset() {
        this.extMask = null;
        this.nameMask = null;
    }

    public void setMask(String string) {
        int n;
        if (string.startsWith(".")) {
            string = "*" + string;
        }
        if (string.endsWith(".")) {
            string = string + "*";
        }
        if ((n = string.indexOf(".")) == -1) {
            n = string.indexOf("*");
            this.nameMask = n == -1 ? string.toCharArray() : string.substring(0, n + 1).toCharArray();
        } else {
            String string2 = string.substring(0, n);
            this.nameMask = (n = string2.indexOf("*")) == -1 ? string2.toCharArray() : string2.substring(0, n + 1).toCharArray();
            string2 = string.substring(n + 2);
            n = string2.indexOf("*");
            char[] cArray = this.extMask = n == -1 ? string2.toCharArray() : string2.substring(0, n + 1).toCharArray();
        }
        if (debuglevel >= 3) {
            DosFilter.debug("set filter file name: \"" + this.nameMask + "\"");
        }
        if (debuglevel >= 3) {
            DosFilter.debug("           file ext.: \"" + this.extMask + "\"");
        }
    }

    public String getMask() {
        return (this.nameMask != null ? new String(this.nameMask) : "*") + "." + (this.extMask != null ? new String(this.extMask) : "*");
    }

    public String toString() {
        return this.getMask();
    }
}

