/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

class LdapNameParser
implements NameParser {
    private static LdapNameParser m_parser;
    static Properties nameSyntax;

    static {
        nameSyntax = new Properties();
        nameSyntax.put("jndi.syntax.direction", "right_to_left");
        nameSyntax.put("jndi.syntax.separator", ",");
        nameSyntax.put("jndi.syntax.ignorecase", "true");
        nameSyntax.put("jndi.syntax.escape", "\\");
        nameSyntax.put("jndi.syntax.beginquote", "\"");
        nameSyntax.put("jndi.syntax.trimblanks", "true");
        nameSyntax.put("jndi.syntax.separator.ava", "+");
        nameSyntax.put("jndi.syntax.separator.typeval", "=");
    }

    private LdapNameParser() {
    }

    public static LdapNameParser getParser() {
        if (m_parser == null) {
            m_parser = new LdapNameParser();
        }
        return m_parser;
    }

    public Name parse(String name) throws NamingException {
        return new CompoundName(name, nameSyntax);
    }

    static String getRDN(String dn) throws NamingException {
        Name parsedName = LdapNameParser.getParser().parse(dn);
        if (parsedName.size() > 0) {
            return parsedName.get(parsedName.size() - 1);
        }
        return "";
    }

    static String getAttrName(String nameEqVal) throws NamingException {
        int eq = nameEqVal.indexOf("=");
        return eq >= 0 ? nameEqVal.substring(0, eq).trim() : null;
    }

    static String getAttrValue(String nameEqVal) throws NamingException {
        int eq = nameEqVal.indexOf("=");
        return eq >= 0 ? nameEqVal.substring(eq + 1).trim() : null;
    }

    static String getRelativeName(String ctx, String entry) throws NamingException {
        if (entry == null) {
            entry = "";
        }
        Name contextName = LdapNameParser.getParser().parse(ctx);
        Name entryName = LdapNameParser.getParser().parse(entry);
        if (!entryName.startsWith(contextName)) {
            throw new NamingException("Name not in context");
        }
        return entryName.getSuffix(contextName.size()).toString();
    }

    static String getRelativeName(Name contextName, String entry) throws NamingException {
        Name entryName;
        if (entry == null) {
            entry = "";
        }
        if (!(entryName = LdapNameParser.getParser().parse(entry)).startsWith(contextName)) {
            throw new NamingException("Name not in context");
        }
        return entryName.getSuffix(contextName.size()).toString();
    }

    public static void main0(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage LdapNameParser <name>");
            System.exit(1);
        }
        try {
            Name name = LdapNameParser.getParser().parse(args[0]);
            System.out.println(name);
            StringBuffer stringBuffer = new StringBuffer("rdn: ");
            LdapNameParser.getParser();
            System.out.println(stringBuffer.append(LdapNameParser.getRDN(args[0])).toString());
            name.add("attr=val");
            System.out.println(name);
            System.out.println(name.get(0));
            System.out.println("in name=val name:<" + LdapNameParser.getAttrName("name=val ") + "> val:<" + LdapNameParser.getAttrValue("name=val ") + ">");
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage LdapNameParser <ctxname> <entryname>");
            System.exit(1);
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("relativeName: ");
            LdapNameParser.getParser();
            System.out.println(stringBuffer.append(LdapNameParser.getRelativeName(args[0], args[1])).toString());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

