/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaElement;
import com.netscape.jndi.ldap.schema.SchemaManager;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttributeSchema;

public class SchemaAttribute
extends SchemaElement {
    LDAPAttributeSchema m_ldapAttribute;
    private static String[] m_allAttrIds = new String[]{"NUMERICOID", "NAME", "DESC", "OBSOLETE", "SUP", "EQUALITY", "ORDERING", "SUBSTRING", "SYNTAX", "SINGLE-VALUE", "COLLECTIVE", "NO-USER-MODIFICATION", "USAGE"};

    public SchemaAttribute(LDAPAttributeSchema ldapAttribute, SchemaManager schemaManager) {
        super(schemaManager);
        this.m_ldapAttribute = ldapAttribute;
        this.m_path = "AttributeDefinition/" + this.m_ldapAttribute.getName();
    }

    public SchemaAttribute(Attributes attrs, SchemaManager schemaManager) throws NamingException {
        super(schemaManager);
        this.m_ldapAttribute = SchemaAttribute.parseDefAttributes(attrs);
        this.m_path = "AttributeDefinition/" + this.m_ldapAttribute.getName();
    }

    static LDAPAttributeSchema parseDefAttributes(Attributes attrs) throws NamingException {
        String name = null;
        String oid = null;
        String desc = null;
        String syntax = null;
        String usage = null;
        String sup = null;
        String equality = null;
        String ordering = null;
        String substring = null;
        boolean singleValued = false;
        boolean collective = false;
        boolean obsolete = false;
        boolean noUserMod = false;
        NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
        while (attrEnum.hasMoreElements()) {
            Attribute attr = (Attribute)attrEnum.nextElement();
            String attrName = attr.getID();
            if (attrName.equals("NAME")) {
                name = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("NUMERICOID")) {
                oid = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("SYNTAX")) {
                syntax = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("DESC")) {
                desc = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("SINGLE-VALUE")) {
                singleValued = SchemaAttribute.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("SUP")) {
                sup = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("USAGE")) {
                usage = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("OBSOLETE")) {
                obsolete = SchemaAttribute.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("COLLECTIVE")) {
                collective = SchemaAttribute.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("NO-USER-MODIFICATION")) {
                noUserMod = SchemaAttribute.parseTrueFalseValue(attr);
                continue;
            }
            if (attrName.equals("EQUALITY")) {
                equality = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("ORDERING")) {
                ordering = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            if (attrName.equals("SUBSTRING")) {
                substring = SchemaAttribute.getSchemaAttrValue(attr);
                continue;
            }
            throw new NamingException("Invalid schema attribute type for attribute definition " + attrName);
        }
        LDAPAttributeSchema attrSchema = new LDAPAttributeSchema(name, oid, desc, syntax, singleValued, sup, null);
        if (obsolete) {
            attrSchema.setQualifier("OBSOLETE", "");
        }
        if (collective) {
            attrSchema.setQualifier("COLLECTIVE", "");
        }
        if (noUserMod) {
            attrSchema.setQualifier("NO-USER-MODIFICATION", "");
        }
        if (equality != null) {
            attrSchema.setQualifier("EQUALITY", equality);
        }
        if (ordering != null) {
            attrSchema.setQualifier("ORDERING", ordering);
        }
        if (substring != null) {
            attrSchema.setQualifier("SUBSTRING", substring);
        }
        if (usage != null) {
            attrSchema.setQualifier("USAGE", usage);
        }
        return attrSchema;
    }

    Attributes extractAttributeIds(String[] attrIds) throws NamingException {
        BasicAttributes attrs = new BasicAttributes();
        String val = null;
        String[] multiVal = null;
        int i = 0;
        while (i < attrIds.length) {
            if (attrIds[i].equals("NUMERICOID")) {
                val = this.m_ldapAttribute.getID();
                if (val != null) {
                    attrs.put(new BasicAttribute("NUMERICOID", val));
                }
            } else if (attrIds[i].equals("NAME")) {
                val = this.m_ldapAttribute.getName();
                if (val != null) {
                    attrs.put(new BasicAttribute("NAME", val));
                }
            } else if (attrIds[i].equals("DESC")) {
                val = this.m_ldapAttribute.getDescription();
                if (val != null) {
                    attrs.put(new BasicAttribute("DESC", val));
                }
            } else if (attrIds[i].equals("SYNTAX")) {
                val = this.m_ldapAttribute.getSyntaxString();
                if (val != null) {
                    attrs.put(new BasicAttribute("SYNTAX", val));
                }
            } else if (attrIds[i].equals("SINGLE-VALUE")) {
                if (this.m_ldapAttribute.isSingleValued()) {
                    attrs.put(new BasicAttribute("SINGLE-VALUE", "true"));
                }
            } else if (attrIds[i].equals("SUP")) {
                val = this.m_ldapAttribute.getSuperior();
                if (val != null) {
                    attrs.put(new BasicAttribute("SUP", val));
                }
            } else if (attrIds[i].equals("USAGE")) {
                multiVal = this.m_ldapAttribute.getQualifier("USAGE");
                if (multiVal != null) {
                    attrs.put(new BasicAttribute("USAGE", multiVal));
                }
            } else if (attrIds[i].equals("OBSOLETE")) {
                if (this.m_ldapAttribute.getQualifier("OBSOLETE") != null) {
                    attrs.put(new BasicAttribute("OBSOLETE", "true"));
                }
            } else if (attrIds[i].equals("COLLECTIVE")) {
                if (this.m_ldapAttribute.getQualifier("COLLECTIVE") != null) {
                    attrs.put(new BasicAttribute("COLLECTIVE", "true"));
                }
            } else if (attrIds[i].equals("NO-USER-MODIFICATION")) {
                if (this.m_ldapAttribute.getQualifier("NO-USER-MODIFICATION") != null) {
                    attrs.put(new BasicAttribute("NO-USER-MODIFICATION", "true"));
                }
            } else if (attrIds[i].equals("EQUALITY")) {
                multiVal = this.m_ldapAttribute.getQualifier("EQUALITY");
                if (multiVal != null) {
                    attrs.put(new BasicAttribute("EQUALITY", multiVal));
                }
            } else if (attrIds[i].equals("ORDERING")) {
                multiVal = this.m_ldapAttribute.getQualifier("ORDERING");
                if (multiVal != null) {
                    attrs.put(new BasicAttribute("ORDERING", multiVal));
                }
            } else if (attrIds[i].equals("SUBSTRING")) {
                multiVal = this.m_ldapAttribute.getQualifier("SUBSTRING");
                if (multiVal != null) {
                    attrs.put(new BasicAttribute("SUBSTRING", multiVal));
                }
            } else {
                throw new NamingException("Invalid schema attribute type for attribute definition " + attrIds[i]);
            }
            ++i;
        }
        return attrs;
    }

    public Attributes getAttributes(String name) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        return this.extractAttributeIds(m_allAttrIds);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        return this.extractAttributeIds(attrIds);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        Attributes modAttrs = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(modAttrs, mod_op, attrs);
        LDAPAttributeSchema modLdapAttribute = SchemaAttribute.parseDefAttributes(modAttrs);
        this.m_schemaMgr.modifyAttribute(this.m_ldapAttribute, modLdapAttribute);
        this.m_ldapAttribute = modLdapAttribute;
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        if (name.length() != 0) {
            throw new NameNotFoundException(name);
        }
        Attributes modAttrs = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(modAttrs, mods);
        LDAPAttributeSchema modLdapAttribute = SchemaAttribute.parseDefAttributes(modAttrs);
        this.m_schemaMgr.modifyAttribute(this.m_ldapAttribute, modLdapAttribute);
        this.m_ldapAttribute = modLdapAttribute;
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }
}

