/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaAttribute;
import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaElementBindingEnum;
import com.netscape.jndi.ldap.schema.SchemaElementContainer;
import com.netscape.jndi.ldap.schema.SchemaElementNameEnum;
import com.netscape.jndi.ldap.schema.SchemaManager;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import netscape.ldap.LDAPAttributeSchema;

public class SchemaAttributeContainer
extends SchemaElementContainer {
    public SchemaAttributeContainer(SchemaManager schemaMgr) throws NamingException {
        super(schemaMgr, "AttributeDefinition");
    }

    public DirContext createSchemaElement(String name, Attributes attrs) throws NamingException {
        if (name.length() == 0) {
            throw new NamingException("Empty name for schema objectclass");
        }
        LDAPAttributeSchema attr = SchemaAttribute.parseDefAttributes(attrs);
        this.m_schemaMgr.createAttribute(attr);
        return new SchemaAttribute(attr, this.m_schemaMgr);
    }

    public void removeSchemaElement(String name) throws NamingException {
        if (name.length() == 0) {
            throw new NamingException("Can not delete schema object container");
        }
        this.m_schemaMgr.removeAttribute(name);
    }

    public NamingEnumeration getNameList(String name) throws NamingException {
        SchemaDirContext schemaObj = (SchemaDirContext)this.lookup(name);
        if (schemaObj == this) {
            return new SchemaElementNameEnum(this.m_schemaMgr.getAttributeNames());
        }
        throw new NotContextException(name);
    }

    public NamingEnumeration getBindingsList(String name) throws NamingException {
        SchemaDirContext schemaObj = (SchemaDirContext)this.lookup(name);
        if (schemaObj == this) {
            return new SchemaElementBindingEnum(this.m_schemaMgr.getAttributes(), this.m_schemaMgr);
        }
        throw new NotContextException(name);
    }

    public Object lookupSchemaElement(String name) throws NamingException {
        if (name.length() == 0) {
            return this;
        }
        LDAPAttributeSchema attr = this.m_schemaMgr.getAttribute(name);
        if (attr == null) {
            throw new NameNotFoundException(name);
        }
        return new SchemaAttribute(attr, this.m_schemaMgr);
    }
}

