/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.common.DirContextAdapter;
import com.netscape.jndi.ldap.schema.SchemaNameParser;
import java.util.NoSuchElementException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;

public class SchemaDirContext
extends DirContextAdapter {
    public static final String CLASSDEF = "ClassDefinition";
    public static final String ATTRDEF = "AttributeDefinition";
    public static final String MRULEDEF = "MatchingRule";
    String m_path;

    public void close() throws NamingException {
    }

    public String composeName(String name, String prefix) throws NamingException {
        return String.valueOf(name) + "," + prefix;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        String compoundName = this.composeName(name.toString(), prefix.toString());
        return SchemaNameParser.getParser().parse(compoundName);
    }

    public String getNameInNamespace() throws NamingException {
        return new String(this.m_path);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return SchemaNameParser.getParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return SchemaNameParser.getParser();
    }

    public void bind(String name, Object obj) throws NamingException {
        if (!(obj instanceof DirContext)) {
            throw new IllegalArgumentException("Can not bind this type of object");
        }
        this.createSubcontext(name, ((DirContext)obj).getAttributes(""));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        try {
            this.bind(name, obj);
        }
        catch (NameAlreadyBoundException ex) {
            this.unbind(name);
            this.bind(name, obj);
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void unbind(String name) throws NamingException {
        this.destroySubcontext(name);
    }

    public void unbind(Name name) throws NamingException {
        this.destroySubcontext(name);
    }

    class EmptyNamingEnumeration
    implements NamingEnumeration {
        EmptyNamingEnumeration() {
        }

        public Object next() throws NamingException {
            throw new NoSuchElementException("EmptyNamingEnumeration");
        }

        public Object nextElement() {
            throw new NoSuchElementException("EmptyNamingEnumeration");
        }

        public boolean hasMore() throws NamingException {
            return false;
        }

        public boolean hasMoreElements() {
            return false;
        }

        public void close() {
        }
    }

    static class SchemaObjectSubordinateNamePair {
        SchemaDirContext schemaObj;
        String subordinateName;

        public SchemaObjectSubordinateNamePair(SchemaDirContext object, String subordinateName) {
            this.schemaObj = object;
            this.subordinateName = subordinateName;
        }

        public String toString() {
            StringBuffer str = new StringBuffer("SchemaObjectSubordinateNamePair{obj:");
            str.append(this.schemaObj == null ? "null" : this.schemaObj.toString());
            str.append(" name:");
            str.append(this.subordinateName);
            str.append("}");
            return str.toString();
        }
    }
}

