/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaElementBindingEnum;
import com.netscape.jndi.ldap.schema.SchemaElementContainer;
import com.netscape.jndi.ldap.schema.SchemaElementNameEnum;
import com.netscape.jndi.ldap.schema.SchemaManager;
import com.netscape.jndi.ldap.schema.SchemaMatchingRule;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import netscape.ldap.LDAPMatchingRuleSchema;

public class SchemaMatchingRuleContainer
extends SchemaElementContainer {
    public SchemaMatchingRuleContainer(SchemaManager schemaMgr) throws NamingException {
        super(schemaMgr, "MatchingRule");
    }

    public DirContext createSchemaElement(String name, Attributes attrs) throws NamingException {
        if (name.length() == 0) {
            throw new NamingException("Empty name for schema objectclass");
        }
        LDAPMatchingRuleSchema mrule = SchemaMatchingRule.parseDefAttributes(attrs);
        this.m_schemaMgr.createMatchingRule(mrule);
        return new SchemaMatchingRule(mrule, this.m_schemaMgr);
    }

    public void removeSchemaElement(String name) throws NamingException {
        if (name.length() == 0) {
            throw new NamingException("Can not delete schema object container");
        }
        this.m_schemaMgr.removeMatchingRule(name);
    }

    public NamingEnumeration getNameList(String name) throws NamingException {
        SchemaDirContext schemaObj = (SchemaDirContext)this.lookup(name);
        if (schemaObj == this) {
            return new SchemaElementNameEnum(this.m_schemaMgr.getMatchingRuleNames());
        }
        throw new NotContextException(name);
    }

    public NamingEnumeration getBindingsList(String name) throws NamingException {
        SchemaDirContext schemaObj = (SchemaDirContext)this.lookup(name);
        if (schemaObj == this) {
            return new SchemaElementBindingEnum(this.m_schemaMgr.getMatchingRules(), this.m_schemaMgr);
        }
        throw new NotContextException(name);
    }

    public Object lookupSchemaElement(String name) throws NamingException {
        if (name.length() == 0) {
            return this;
        }
        LDAPMatchingRuleSchema mrule = this.m_schemaMgr.getMatchingRule(name);
        if (mrule == null) {
            throw new NameNotFoundException(name);
        }
        return new SchemaMatchingRule(mrule, this.m_schemaMgr);
    }
}

