/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaAttributeContainer;
import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaManager;
import com.netscape.jndi.ldap.schema.SchemaMatchingRuleContainer;
import com.netscape.jndi.ldap.schema.SchemaObjectClassContainer;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPConnection;

public class SchemaRoot
extends SchemaDirContext {
    static final String m_className = "javax.naming.directory.DirContext";
    SchemaDirContext m_classContainer;
    SchemaDirContext m_attrContainer;
    SchemaDirContext m_matchRuleContainer;
    SchemaManager m_schemaMgr;

    public SchemaRoot(LDAPConnection ld) throws NamingException {
        this.m_path = "";
        this.m_schemaMgr = new SchemaManager(ld);
        this.m_classContainer = new SchemaObjectClassContainer(this.m_schemaMgr);
        this.m_attrContainer = new SchemaAttributeContainer(this.m_schemaMgr);
        this.m_matchRuleContainer = new SchemaMatchingRuleContainer(this.m_schemaMgr);
    }

    SchemaDirContext.SchemaObjectSubordinateNamePair resolveSchemaObject(String name) throws NamingException {
        SchemaDirContext obj = null;
        if (name.length() == 0) {
            obj = this;
        } else if (name.startsWith("ClassDefinition") || name.startsWith("ClassDefinition".toLowerCase())) {
            name = name.substring("ClassDefinition".length());
            obj = this.m_classContainer;
        } else if (name.startsWith("AttributeDefinition") || name.startsWith("AttributeDefinition".toLowerCase())) {
            name = name.substring("AttributeDefinition".length());
            obj = this.m_attrContainer;
        } else if (name.startsWith("MatchingRule") || name.startsWith("MatchingRule".toLowerCase())) {
            name = name.substring("MatchingRule".length());
            obj = this.m_matchRuleContainer;
        } else {
            throw new NameNotFoundException(name);
        }
        if (name.length() > 1 && name.startsWith("/")) {
            name = name.substring(1);
        }
        return new SchemaDirContext.SchemaObjectSubordinateNamePair(obj, name);
    }

    public Attributes getAttributes(String name) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        return objNamePair.schemaObj.getAttributes(objNamePair.subordinateName);
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        return objNamePair.schemaObj.getAttributes(objNamePair.subordinateName, attrIds);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        return objNamePair.schemaObj.createSubcontext(objNamePair.subordinateName, attrs);
    }

    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public void destroySubcontext(String name) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        objNamePair.schemaObj.destroySubcontext(objNamePair.subordinateName);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (!(obj instanceof DirContext)) {
            throw new IllegalArgumentException("Can not bind this type of object");
        }
        this.createSubcontext(name, ((DirContext)obj).getAttributes(""));
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.unbind(name);
        this.bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void unbind(String name) throws NamingException {
        this.destroySubcontext(name);
    }

    public void unbind(Name name) throws NamingException {
        this.destroySubcontext(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            return new SchemaRootNameClassPairEnum();
        }
        return objNamePair.schemaObj.list(objNamePair.subordinateName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            return new SchemaRootBindingEnum();
        }
        return objNamePair.schemaObj.listBindings(objNamePair.subordinateName);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair objNamePair = this.resolveSchemaObject(name);
        if (objNamePair.schemaObj == this) {
            return this;
        }
        return objNamePair.schemaObj.lookup(objNamePair.subordinateName);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public static void main(String[] args) {
        try {
            String name = args[0];
            System.out.println(new SchemaRoot(null).resolveSchemaObject(name));
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    class SchemaRootNameClassPairEnum
    implements NamingEnumeration {
        private int m_idx = -1;

        SchemaRootNameClassPairEnum() {
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            ++this.m_idx;
            if (this.m_idx == 0) {
                return new NameClassPair("ClassDefinition", SchemaRoot.m_className);
            }
            if (this.m_idx == 1) {
                return new NameClassPair("AttributeDefinition", SchemaRoot.m_className);
            }
            if (this.m_idx == 2) {
                return new NameClassPair("MatchingRule", SchemaRoot.m_className);
            }
            throw new NoSuchElementException("SchemaRootEnumerator");
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.m_idx < 2;
        }

        public void close() {
        }
    }

    class SchemaRootBindingEnum
    implements NamingEnumeration {
        private int m_idx = -1;

        SchemaRootBindingEnum() {
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            ++this.m_idx;
            if (this.m_idx == 0) {
                return new Binding("ClassDefinition", SchemaRoot.m_className, SchemaRoot.this.m_classContainer);
            }
            if (this.m_idx == 1) {
                return new Binding("AttributeDefinition", SchemaRoot.m_className, SchemaRoot.this.m_attrContainer);
            }
            if (this.m_idx == 2) {
                return new Binding("MatchingRule", SchemaRoot.m_className, SchemaRoot.this.m_matchRuleContainer);
            }
            throw new NoSuchElementException("SchemaRootEnumerator");
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.m_idx < 2;
        }

        public void close() {
        }
    }
}

