/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSyntaxSchemaElement;

public class LDAPAttributeSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = 2482595821879862595L;
    public static final String EQUALITY = "EQUALITY";
    public static final String ORDERING = "ORDERING";
    public static final String SUBSTR = "SUBSTR";
    public static final String SINGLE = "SINGLE-VALUE";
    public static final String COLLECTIVE = "COLLECTIVE";
    public static final String NO_USER_MODIFICATION = "NO-USER-MODIFICATION";
    public static final String USAGE = "USAGE";
    static String[] NOVALS = new String[]{"SINGLE-VALUE", "COLLECTIVE", "NO-USER-MODIFICATION"};
    static final String[] MATCHING_RULES;
    static final String[] IGNOREVALS;
    protected LDAPSyntaxSchemaElement syntaxElement = new LDAPSyntaxSchemaElement();

    static {
        int i = 0;
        while (i < NOVALS.length) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
            ++i;
        }
        MATCHING_RULES = new String[]{EQUALITY, ORDERING, SUBSTR};
        IGNOREVALS = new String[]{SINGLE, "OBSOLETE", "SUP", SINGLE, COLLECTIVE, NO_USER_MODIFICATION, "SYNTAX"};
    }

    protected LDAPAttributeSchema() {
    }

    public LDAPAttributeSchema(String name, String oid, String description, int syntax, boolean single) {
        this(name, oid, description, "1.3.6.1.4.1.1466.115.121.1.15", single);
        this.syntaxElement.syntax = syntax;
        String syntaxType = LDAPSyntaxSchemaElement.internalSyntaxToString(syntax);
        if (syntaxType != null) {
            this.syntaxElement.syntaxString = syntaxType;
        }
        this.setQualifier("SYNTAX", this.getSyntaxString());
    }

    public LDAPAttributeSchema(String name, String oid, String description, String syntaxString, boolean single) {
        this(name, oid, description, syntaxString, single, null, null);
    }

    public LDAPAttributeSchema(String name, String oid, String description, String syntaxString, boolean single, String superior, String[] aliases) {
        super(name, oid, description, aliases);
        this.attrName = "attributetypes";
        this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(syntaxString);
        this.syntaxElement.syntaxString = syntaxString;
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
        if (single) {
            this.setQualifier(SINGLE, "");
        }
        if (superior != null && superior.length() > 0) {
            this.setQualifier("SUP", superior);
        }
    }

    public LDAPAttributeSchema(String raw) {
        this.attrName = "attributetypes";
        this.parseValue(raw);
        String val = (String)this.properties.get("SYNTAX");
        if (val != null) {
            this.syntaxElement.syntaxString = val;
            this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(val);
        }
    }

    public boolean isSingleValued() {
        return this.properties != null ? this.properties.containsKey(SINGLE) : false;
    }

    public String getSuperior() {
        String[] val = this.getQualifier("SUP");
        return val != null && val.length > 0 ? val[0] : null;
    }

    public int getSyntax() {
        return this.syntaxElement.syntax;
    }

    public String getSyntaxString() {
        return this.syntaxElement.syntaxString;
    }

    String getValue(boolean quotingBug) {
        String s = this.getValuePrefix();
        String val = this.getValue("SUP", false);
        if (val.length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if ((val = this.getOptionalValues(MATCHING_RULES)).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if ((val = this.getValue("SYNTAX", quotingBug)).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if (this.isSingleValued()) {
            s = String.valueOf(s) + "SINGLE-VALUE ";
        }
        if ((val = this.getOptionalValues(NOVALS)).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if ((val = this.getOptionalValues(new String[]{USAGE})).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        s = String.valueOf(s) + this.syntaxElement.syntaxToString();
        s = String.valueOf(s) + "; Description: " + this.description + "; ";
        s = this.isSingleValued() ? String.valueOf(s) + "single-valued" : String.valueOf(s) + "multi-valued";
        s = String.valueOf(s) + this.getQualifierString(IGNOREVALS);
        s = String.valueOf(s) + this.getAliasString();
        return s;
    }
}

