/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.util.LDIF;

public class LDAPControl
implements Cloneable,
Serializable {
    static final long serialVersionUID = 5149887553272603753L;
    public static final String MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    public static final String PWEXPIRED = "2.16.840.1.113730.3.4.4";
    public static final String PWEXPIRING = "2.16.840.1.113730.3.4.5";
    private String m_oid;
    protected boolean m_critical = false;
    protected byte[] m_value = null;
    private static Hashtable m_controlClassHash = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("netscape.ldap.controls.LDAPPasswordExpiringControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LDAPControl.register(PWEXPIRING, clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("netscape.ldap.controls.LDAPPasswordExpiredControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LDAPControl.register(PWEXPIRED, clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("netscape.ldap.controls.LDAPEntryChangeControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LDAPControl.register("2.16.840.1.113730.3.4.7", clazz3);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("netscape.ldap.controls.LDAPSortControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LDAPControl.register("1.2.840.113556.1.4.474", clazz4);
            Class<?> clazz5 = class$4;
            if (clazz5 == null) {
                try {
                    clazz5 = class$4 = Class.forName("netscape.ldap.controls.LDAPVirtualListResponse");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LDAPControl.register("2.16.840.1.113730.3.4.10", clazz5);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    public LDAPControl() {
    }

    public LDAPControl(String id, boolean critical, byte[] vals) {
        this.m_oid = id;
        this.m_critical = critical;
        this.m_value = vals;
    }

    public String getID() {
        return this.m_oid;
    }

    public boolean isCritical() {
        return this.m_critical;
    }

    public byte[] getValue() {
        return this.m_value;
    }

    BERElement getBERElement() {
        BERSequence seq = new BERSequence();
        seq.addElement(new BEROctetString(this.m_oid));
        seq.addElement(new BERBoolean(this.m_critical));
        if (this.m_value == null || this.m_value.length < 1) {
            seq.addElement(new BEROctetString(null));
        } else {
            seq.addElement(new BEROctetString(this.m_value, 0, this.m_value.length));
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void register(String oid, Class controlClass) throws LDAPException {
        if (controlClass == null) {
            return;
        }
        Class superClass = controlClass;
        while (true) {
            Class<?> clazz;
            if ((clazz = class$5) == null) {
                try {
                    clazz = Class.forName("netscape.ldap.LDAPControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (superClass == clazz || superClass == null) {
                if (superClass != null) break;
                throw new LDAPException("controlClass must be a subclass of LDAPControl", 89);
            }
            superClass = superClass.getSuperclass();
        }
        Class[] classArray = new Class[3];
        Class<?> clazz = class$6;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$6 = clazz2;
        }
        classArray[0] = clazz;
        classArray[1] = Boolean.TYPE;
        Class<?> clazz3 = class$8;
        if (clazz3 == null) {
            Class<?> clazz4;
            try {
                clazz4 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz3 = class$8 = clazz4;
        }
        classArray[2] = clazz3;
        Class[] cparams = classArray;
        try {
            controlClass.getConstructor(cparams);
        }
        catch (NoSuchMethodException e) {
            throw new LDAPException("controlClass does not implement the correct contstructor", 89);
        }
        if (m_controlClassHash == null) {
            m_controlClassHash = new Hashtable();
        }
        m_controlClassHash.put(oid, controlClass);
    }

    protected static Class lookupControlClass(String oid) {
        if (m_controlClassHash == null) {
            return null;
        }
        return (Class)m_controlClassHash.get(oid);
    }

    protected static LDAPControl createControl(String oid, boolean critical, byte[] value) {
        Class controlClass = LDAPControl.lookupControlClass(oid);
        if (controlClass == null) {
            return new LDAPControl(oid, critical, value);
        }
        Class[] classArray = new Class[3];
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Boolean.TYPE;
        Class<?> clazz2 = class$8;
        if (clazz2 == null) {
            try {
                clazz2 = class$8 = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz2;
        Class[] cparams = classArray;
        Constructor creator = null;
        try {
            creator = controlClass.getConstructor(cparams);
        }
        catch (NoSuchMethodException e) {
            System.err.println("Caught java.lang.NoSuchMethodException while attempting to instantiate a control of type " + oid);
            return new LDAPControl(oid, critical, value);
        }
        Object[] oparams = new Object[]{oid, new Boolean(critical), value};
        LDAPControl returnControl = null;
        try {
            returnControl = (LDAPControl)creator.newInstance(oparams);
        }
        catch (Exception e) {
            String eString = null;
            eString = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException().toString() : e.toString();
            System.err.println("Caught " + eString + " while attempting to" + " instantiate a control of type " + oid);
            returnControl = new LDAPControl(oid, critical, value);
        }
        return returnControl;
    }

    static LDAPControl parseControl(BERElement el) {
        BERSequence s = (BERSequence)el;
        String oid = null;
        boolean critical = false;
        byte[] value = null;
        try {
            oid = new String(((BEROctetString)s.elementAt(0)).getValue(), "UTF8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BERElement obj = s.elementAt(1);
        if (obj instanceof BERBoolean) {
            critical = ((BERBoolean)obj).getValue();
        } else {
            value = ((BEROctetString)obj).getValue();
        }
        if (s.size() >= 3) {
            value = ((BEROctetString)s.elementAt(2)).getValue();
        }
        return LDAPControl.createControl(oid, critical, value);
    }

    /*
     * Unable to fully structure code
     */
    public static LDAPControl[] newInstance(byte[] data) throws IOException {
        block3: {
            bread = new int[1];
            el = BERElement.getElement(new JDAPBERTagDecoder(), new ByteArrayInputStream(data), bread);
            jc = null;
            try {
                msg = LDAPMessage.parseMessage(el);
                return msg.getControls();
            }
            catch (IOException e) {
                tag = (BERTag)el;
                if (tag.getTag() != 160) break block3;
                controls = (BERSequence)tag.getValue();
                jc = new LDAPControl[controls.size()];
                i = 0;
                ** while (i < controls.size())
            }
lbl-1000:
            // 1 sources

            {
                jc[i] = LDAPControl.parseControl(controls.elementAt(i));
                ++i;
                continue;
            }
        }
        return jc;
    }

    public Object clone() {
        byte[] vals = null;
        if (this.m_value != null) {
            vals = new byte[this.m_value.length];
            int i = 0;
            while (i < this.m_value.length) {
                vals[i] = this.m_value[i];
                ++i;
            }
        }
        LDAPControl control = new LDAPControl(this.m_oid, this.m_critical, vals);
        return control;
    }

    protected byte[] flattenBER(BERSequence ber) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            ber.write(outStream);
        }
        catch (IOException e) {
            return null;
        }
        return outStream.toByteArray();
    }

    public String toString() {
        if (this.getID().equals(MANAGEDSAIT)) {
            return "{MANAGEDSITControl: isCritical=" + this.isCritical() + "}";
        }
        String s = String.valueOf(this.getID()) + ' ' + this.isCritical();
        if (this.m_value != null) {
            s = String.valueOf(s) + ' ' + LDIF.toPrintableString(this.m_value);
        }
        return "LDAPControl {" + s + '}';
    }
}

