/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPSchemaElement;

public class LDAPDITStructureRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -2823317246039655811L;
    public static final String FORM = "FORM";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private String nameForm = null;
    private int ruleID = 0;

    static {
        int i = 0;
        while (i < NOVALS.length) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
            ++i;
        }
        IGNOREVALS = new String[]{"OBSOLETE", FORM, "SUP"};
    }

    protected LDAPDITStructureRuleSchema() {
    }

    public LDAPDITStructureRuleSchema(String name, int ruleID, String description, boolean obsolete, String nameForm, String[] superiors) {
        super(name, "", description, null);
        this.nameForm = nameForm;
        this.ruleID = ruleID;
        if (obsolete) {
            this.setQualifier("OBSOLETE", "");
        }
        if (superiors != null && superiors.length > 0) {
            this.setQualifier("SUP", superiors);
        }
    }

    public LDAPDITStructureRuleSchema(String raw) {
        this.attrName = "ditStructureRules";
        this.parseValue(raw);
        Object o = this.properties.get(FORM);
        if (o != null) {
            this.nameForm = (String)o;
        }
        try {
            this.ruleID = Integer.parseInt(this.oid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getSuperiors() {
        return this.getQualifier("SUP");
    }

    public int getRuleID() {
        return this.ruleID;
    }

    public String getNameForm() {
        return this.nameForm;
    }

    public String getValue() {
        String s = "( " + this.ruleID + ' ';
        if (this.name != null) {
            s = String.valueOf(s) + "NAME '" + this.name + "' ";
        }
        if (this.description != null) {
            s = String.valueOf(s) + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            s = String.valueOf(s) + "OBSOLETE ";
        }
        s = String.valueOf(s) + "FORM " + this.nameForm + ' ';
        String val = this.getValue("SUP", false);
        if (val != null && val.length() > 1) {
            s = String.valueOf(s) + val + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String toString() {
        String[] superiors;
        String s = "Name: " + this.name + "; ruleID: " + this.ruleID + "; ";
        s = String.valueOf(s) + "Description: " + this.description;
        if (this.isObsolete()) {
            s = String.valueOf(s) + "; OBSOLETE";
        }
        if ((superiors = this.getSuperiors()) != null) {
            int i = 0;
            while (i < superiors.length) {
                s = String.valueOf(s) + superiors[i];
                if (i < superiors.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "Name form: " + this.nameForm + "; ";
        s = String.valueOf(s) + this.getQualifierString(IGNOREVALS);
        return s;
    }
}

