/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPAttributeSchema;

public class LDAPMatchingRuleUseSchema
extends LDAPAttributeSchema {
    static final String[] EXPLICIT = new String[]{"OBSOLETE"};
    private String[] attributes = null;

    public LDAPMatchingRuleUseSchema(String name, String oid, String description, String[] attributes) {
        if (oid == null || oid.trim().length() < 1) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = name;
        this.oid = oid;
        this.description = description;
        this.attrName = "matchingruleuse";
        this.attributes = new String[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            this.attributes[i] = attributes[i];
            ++i;
        }
    }

    public LDAPMatchingRuleUseSchema(String use) {
        this.attrName = "matchingruleuse";
        this.parseValue(use);
        Vector v = (Vector)this.properties.get("APPLIES");
        if (v != null) {
            this.attributes = new String[v.size()];
            v.copyInto(this.attributes);
            v.removeAllElements();
        }
    }

    public String[] getApplicableAttributes() {
        return this.attributes;
    }

    public String getValue() {
        String s = this.getValuePrefix();
        if (this.attributes != null && this.attributes.length > 0) {
            s = String.valueOf(s) + "APPLIES ( ";
            int i = 0;
            while (i < this.attributes.length) {
                if (i > 0) {
                    s = String.valueOf(s) + " $ ";
                }
                s = String.valueOf(s) + this.attributes[i];
                ++i;
            }
            s = String.valueOf(s) + " ) ";
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid;
        s = String.valueOf(s) + "; Description: " + this.description;
        if (this.attributes != null) {
            s = String.valueOf(s) + "; Applies to: ";
            int i = 0;
            while (i < this.attributes.length) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + this.attributes[i];
                ++i;
            }
        }
        s = String.valueOf(s) + this.getQualifierString(EXPLICIT);
        return s;
    }
}

