/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPObjectClassSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -1732784695071118656L;
    public static final int STRUCTURAL = 0;
    public static final int ABSTRACT = 1;
    public static final int AUXILIARY = 2;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private int type = 0;
    static final String[] NOVALS = new String[]{"ABSTRACT", "STRUCTURAL", "AUXILIARY", "OBSOLETE"};
    static final String[] IGNOREVALS;
    static final String TYPE = "TYPE";

    static {
        int i = 0;
        while (i < NOVALS.length) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
            ++i;
        }
        IGNOREVALS = new String[]{"ABSTRACT", "STRUCTURAL", "AUXILIARY", "MUST", "MAY", "SUP", "OBSOLETE"};
    }

    public LDAPObjectClassSchema(String name, String oid, String superior, String description, String[] required, String[] optional) {
        this(name, oid, superior, description, required, optional, null);
    }

    public LDAPObjectClassSchema(String name, String oid, String[] superiors, String description, String[] required, String[] optional, int type, String[] aliases) {
        this(name, oid, superiors != null && superiors.length > 0 ? superiors[0] : null, description, required, optional, aliases);
        if (superiors != null && superiors.length > 1) {
            this.setQualifier("SUP", superiors);
        }
        this.setQualifier(TYPE, this.typeToString(type));
    }

    protected LDAPObjectClassSchema(String name, String oid, String superior, String description, String[] required, String[] optional, String[] aliases) {
        super(name, oid, description, aliases);
        int i;
        this.attrName = "objectclasses";
        this.setQualifier("SUP", superior);
        if (required != null) {
            i = 0;
            while (i < required.length) {
                this.must.addElement(required[i]);
                ++i;
            }
        }
        if (optional != null) {
            i = 0;
            while (i < optional.length) {
                this.may.addElement(optional[i]);
                ++i;
            }
        }
    }

    public LDAPObjectClassSchema(String raw) {
        this.attrName = "objectclasses";
        this.parseValue(raw);
        this.setQualifier(TYPE, this.typeToString(this.getType()));
        Object o = this.properties.get("MAY");
        if (o != null) {
            if (o instanceof Vector) {
                this.may = (Vector)o;
            } else {
                this.may.addElement(o);
            }
        }
        if ((o = this.properties.get("MUST")) != null) {
            if (o instanceof Vector) {
                this.must = (Vector)o;
            } else {
                this.must.addElement(o);
            }
        }
    }

    public String getSuperior() {
        String[] superiors = this.getSuperiors();
        return superiors != null ? superiors[0] : null;
    }

    public String[] getSuperiors() {
        return this.getQualifier("SUP");
    }

    public Enumeration getRequiredAttributes() {
        return this.must.elements();
    }

    public Enumeration getOptionalAttributes() {
        return this.may.elements();
    }

    public int getType() {
        int type = 0;
        if (this.properties.containsKey("AUXILIARY")) {
            type = 2;
        } else if (this.properties.containsKey("ABSTRACT")) {
            type = 1;
        }
        return type;
    }

    String getValue(boolean quotingBug) {
        String[] vals;
        String s = this.getValuePrefix();
        String val = this.getValue("SUP", quotingBug);
        if (val != null && val.length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if ((vals = this.getQualifier(TYPE)) != null && vals.length > 0) {
            s = String.valueOf(s) + vals[0] + ' ';
        }
        if ((val = this.getOptionalValues(NOVALS)).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        if (this.must.size() > 0) {
            s = String.valueOf(s) + "MUST " + this.vectorToList(this.must);
            s = String.valueOf(s) + ' ';
        }
        if (this.may.size() > 0) {
            s = String.valueOf(s) + "MAY " + this.vectorToList(this.may);
            s = String.valueOf(s) + ' ';
        }
        if ((val = this.getCustomValues()).length() > 0) {
            s = String.valueOf(s) + val + ' ';
        }
        s = String.valueOf(s) + ')';
        return s;
    }

    public String toString() {
        int i;
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Superior: ";
        String[] superiors = this.getSuperiors();
        if (superiors != null) {
            i = 0;
            while (i < superiors.length) {
                s = String.valueOf(s) + superiors[i];
                if (i < superiors.length - 1) {
                    s = String.valueOf(s) + ", ";
                }
                ++i;
            }
        }
        s = String.valueOf(s) + "; Description: " + this.description + "; Required: ";
        i = 0;
        Enumeration e = this.getRequiredAttributes();
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + "; Optional: ";
        e = this.getOptionalAttributes();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        String[] vals = this.getQualifier(TYPE);
        if (vals != null && vals.length > 0) {
            s = String.valueOf(s) + "; " + vals[0];
        }
        if (this.isObsolete()) {
            s = String.valueOf(s) + "; OBSOLETE";
        }
        s = String.valueOf(s) + this.getQualifierString(IGNOREVALS);
        s = String.valueOf(s) + this.getAliasString();
        return s;
    }

    protected String vectorToList(Vector vals) {
        String val = "( ";
        int i = 0;
        while (i < vals.size()) {
            val = String.valueOf(val) + (String)vals.elementAt(i) + ' ';
            if (i < vals.size() - 1) {
                val = String.valueOf(val) + "$ ";
            }
            ++i;
        }
        val = String.valueOf(val) + ')';
        return val;
    }

    protected String typeToString(int type) {
        switch (type) {
            case 0: {
                return "STRUCTURAL";
            }
            case 1: {
                return "ABSTRACT";
            }
            case 2: {
                return "AUXILIARY";
            }
        }
        return null;
    }
}

