/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import netscape.ldap.DynamicInvoker;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPBindResponse;
import netscape.ldap.client.opers.JDAPProtocolOp;

public class LDAPSaslBind
implements LDAPBind,
Serializable {
    static final long serialVersionUID = -7615315715163655443L;
    private static final String CALLBACK_HANDLER = "javax.security.auth.callback.CallbackHandler";
    private static final String CLIENTPKGS = "javax.security.sasl.client.pkgs";
    private String _dn;
    private String[] _mechanisms;
    private String _packageName;
    private Hashtable _props;
    private Object _cbh;
    private Object _saslClient = null;

    public LDAPSaslBind(String dn, String[] mechanisms, String packageName, Hashtable props, Object cbh) {
        this._dn = dn;
        this._mechanisms = mechanisms;
        this._packageName = packageName;
        this._props = props;
        this._cbh = cbh;
    }

    public void bind(LDAPConnection ldc) throws LDAPException {
        if (this._props == null) {
            this._props = new Hashtable();
        }
        if (!this._props.containsKey(CLIENTPKGS) && System.getProperty(CLIENTPKGS) == null) {
            this._props.put(CLIENTPKGS, "com.netscape.sasl");
        }
        this._saslClient = this.getClient(ldc, this._packageName);
        if (this._saslClient != null) {
            this.bind(ldc, true);
            return;
        }
        LDAPConnection.printDebug("LDAPSaslBind.bind: getClient returned null");
    }

    private Object getClient(LDAPConnection ldc, String packageName) throws LDAPException {
        try {
            Object[] args = new Object[]{this._mechanisms, this._dn, "ldap", ldc.getHost(), this._props, this._cbh};
            String[] argNames = new String[]{"[Ljava.lang.String;", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Hashtable", CALLBACK_HANDLER};
            return DynamicInvoker.invokeMethod(null, String.valueOf(packageName) + ".Sasl", "createSaslClient", args, argNames);
        }
        catch (Exception e) {
            LDAPConnection.printDebug("LDAPSaslBind.getClient: " + packageName + ".Sasl.createSaslClient: " + e);
            throw new LDAPException(e.toString(), 80);
        }
    }

    void bind(LDAPConnection ldc, boolean rebind) throws LDAPException {
        if (ldc.isConnected() && rebind || !ldc.isConnected()) {
            try {
                String[] argNames;
                Object[] args;
                String className = this._saslClient.getClass().getName();
                LDAPConnection.printDebug("LDAPSaslBind.bind: calling " + className + ".createInitialResponse");
                byte[] outVals = (byte[])DynamicInvoker.invokeMethod(this._saslClient, className, "createInitialResponse", null, null);
                String mechanismName = (String)DynamicInvoker.invokeMethod(this._saslClient, className, "getMechanismName", null, null);
                LDAPConnection.printDebug("LDAPSaslBind.bind: mechanism name is " + mechanismName);
                boolean isExternal = this.isExternalMechanism(mechanismName);
                int resultCode = 14;
                JDAPBindResponse response = null;
                while (!this.checkForSASLBindCompletion(resultCode)) {
                    LDAPConnection.printDebug("LDAPSaslBind.bind: calling saslBind");
                    response = this.saslBind(ldc, mechanismName, outVals);
                    resultCode = response.getResultCode();
                    LDAPConnection.printDebug("LDAPSaslBind.bind: saslBind returned " + resultCode);
                    if (isExternal) continue;
                    byte[] b = response.getCredentials();
                    args = new Object[]{b};
                    argNames = new String[]{"[B"};
                    outVals = (byte[])DynamicInvoker.invokeMethod(this._saslClient, className, "evaluateChallenge", args, argNames);
                }
                Boolean bool = (Boolean)DynamicInvoker.invokeMethod(this._saslClient, className, "isComplete", null, null);
                if (!bool.booleanValue()) {
                    throw new LDAPException("The server indicates that authentication is successful, but the SASL driver indicates that authentication is not yet done.", 80);
                }
                args = new Object[]{ldc.getInputStream()};
                argNames = new String[]{"java.io.InputStream"};
                InputStream is = (InputStream)DynamicInvoker.invokeMethod(this._saslClient, className, "getInputStream", args, argNames);
                ldc.setInputStream(is);
                args[0] = ldc.getOutputStream();
                argNames[0] = "java.io.OutputStream";
                OutputStream os = (OutputStream)DynamicInvoker.invokeMethod(this._saslClient, className, "getOutputStream", args, argNames);
                ldc.setOutputStream(os);
                ldc.setBound(true);
            }
            catch (LDAPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LDAPException(e.toString(), 80);
            }
        }
    }

    boolean isExternalMechanism(String name) {
        return name.equalsIgnoreCase("external");
    }

    private boolean checkForSASLBindCompletion(int resultCode) throws LDAPException {
        if (resultCode == 0) {
            return true;
        }
        if (resultCode == 14) {
            return false;
        }
        throw new LDAPException("Authentication failed", resultCode);
    }

    private JDAPBindResponse saslBind(LDAPConnection ldc, String mechanismName, byte[] credentials) throws LDAPException {
        block3: {
            LDAPResponseListener myListener = ldc.getResponseListener();
            try {
                ldc.sendRequest(new JDAPBindRequest(3, this._dn, mechanismName, credentials), myListener, ldc.getConstraints());
                LDAPResponse response = myListener.getResponse();
                JDAPProtocolOp protocolOp = response.getProtocolOp();
                if (!(protocolOp instanceof JDAPBindResponse)) break block3;
                JDAPBindResponse jDAPBindResponse = (JDAPBindResponse)protocolOp;
                Object var7_8 = null;
                ldc.releaseResponseListener(myListener);
                return jDAPBindResponse;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                ldc.releaseResponseListener(myListener);
                throw throwable;
            }
        }
        throw new LDAPException("Unknown response from the server during SASL bind", 80);
    }
}

