/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;

public abstract class LDAPSchemaElement
implements Serializable {
    static final long serialVersionUID = -3972153461950418863L;
    public static final int unknown = 0;
    public static final int cis = 1;
    public static final int binary = 2;
    public static final int telephone = 3;
    public static final int ces = 4;
    public static final int dn = 5;
    public static final int integer = 6;
    protected static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    protected static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    protected static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    protected static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    protected static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    protected static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final String OBSOLETE = "OBSOLETE";
    public static final String SUPERIOR = "SUP";
    public static final String SYNTAX = "SYNTAX";
    protected String oid = null;
    protected String name = "";
    protected String description = "";
    protected String attrName = null;
    protected String rawValue = null;
    protected String[] aliases = null;
    protected Hashtable properties = null;
    protected static Hashtable novalsTable = new Hashtable();

    protected LDAPSchemaElement() {
    }

    protected LDAPSchemaElement(String name, String oid, String description) {
        this(name, oid, description, null);
    }

    protected LDAPSchemaElement(String name, String oid, String description, String[] aliases) {
        if (oid == null) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = name;
        this.oid = oid;
        this.description = description;
        if (aliases != null && aliases.length > 0) {
            this.aliases = aliases;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.oid;
    }

    public String getOID() {
        return this.getID();
    }

    public String getDescription() {
        return this.description;
    }

    protected void update(LDAPConnection ld, int op, LDAPAttribute attr, String dn) throws LDAPException {
        LDAPAttribute[] attrs = new LDAPAttribute[]{attr};
        this.update(ld, op, attrs, dn);
    }

    protected void update(LDAPConnection ld, int op, LDAPAttribute[] attrs, String dn) throws LDAPException {
        LDAPModificationSet mods = new LDAPModificationSet();
        int i = 0;
        while (i < attrs.length) {
            mods.add(op, attrs[i]);
            ++i;
        }
        String entryName = LDAPSchema.getSchemaDN(ld, dn);
        ld.modify(entryName, mods);
    }

    protected void update(LDAPConnection ld, int op, String name, String dn) throws LDAPException {
        boolean quotingBug = !LDAPSchema.isAttributeSyntaxStandardsCompliant(ld);
        LDAPAttribute attr = new LDAPAttribute(name, this.getValue(quotingBug));
        this.update(ld, op, attr, dn);
    }

    public void add(LDAPConnection ld, String dn) throws LDAPException {
        this.update(ld, 0, this.attrName, dn);
    }

    public void add(LDAPConnection ld) throws LDAPException {
        this.add(ld, "");
    }

    public void modify(LDAPConnection ld, LDAPSchemaElement newValue, String dn) throws LDAPException {
        boolean quotingBug = !LDAPSchema.isAttributeSyntaxStandardsCompliant(ld);
        LDAPModificationSet mods = new LDAPModificationSet();
        mods.add(1, new LDAPAttribute(this.attrName, this.getValue(quotingBug)));
        mods.add(0, new LDAPAttribute(this.attrName, newValue.getValue(quotingBug)));
        String entryName = LDAPSchema.getSchemaDN(ld, dn);
        ld.modify(entryName, mods);
    }

    public void modify(LDAPConnection ld, LDAPSchemaElement newValue) throws LDAPException {
        this.modify(ld, newValue, "");
    }

    public void remove(LDAPConnection ld, String dn) throws LDAPException {
        this.update(ld, 1, this.attrName, dn);
    }

    public void remove(LDAPConnection ld) throws LDAPException {
        this.remove(ld, "");
    }

    public boolean isObsolete() {
        return this.properties == null ? false : this.properties.containsKey(OBSOLETE);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    protected void parseValue(String raw) {
        if (this.properties == null) {
            this.properties = new Hashtable<K, V>();
        }
        l = raw.length();
        ch = new char[l];
        raw.getChars(0, l, ch, 0);
        --l;
        while (ch[l] == ' ') {
            --l;
        }
        start = 0;
        while (ch[start] == ' ') {
            ++start;
        }
        ind = (start += 2) + 1;
        while (ch[ind] != ' ') {
            ++ind;
        }
        this.oid = new String(ch, start, ind - start);
        ++ind;
        ** GOTO lbl95
        {
            ++ind;
            do {
                block24: {
                    block25: {
                        block23: {
                            block22: {
                                block21: {
                                    if (ch[ind] == ' ') continue block3;
                                    last = ind + 1;
                                    while (last < l && ch[last] != ' ') {
                                        ++last;
                                    }
                                    if (last >= l) break block21;
                                    s = new String(ch, ind, last - ind);
                                    ind = last;
                                    if (LDAPSchemaElement.novalsTable.containsKey(s)) {
                                        this.properties.put(s, "");
                                        continue;
                                    }
                                    ** GOTO lbl41
                                }
                                s = "";
                                ind = l;
                                break block3;
lbl-1000:
                                // 1 sources

                                {
                                    ++ind;
lbl41:
                                    // 2 sources

                                    ** while (ind < l && ch[ind] == ' ')
                                }
lbl42:
                                // 1 sources

                                last = ind + 1;
                                if (ind >= l) break block3;
                                quoted = false;
                                list = false;
                                if (ch[ind] != '\'') break block22;
                                quoted = true;
                                ++ind;
                                if (true) ** GOTO lbl57
                            }
                            if (ch[ind] != '(') ** GOTO lbl64
                            list = true;
                            ++ind;
                            if (true) ** GOTO lbl61
                            do {
                                ++last;
lbl57:
                                // 2 sources

                            } while (last < l && ch[last] != '\'');
                            break block23;
                            do {
                                ++last;
lbl61:
                                // 2 sources

                            } while (last < l && ch[last] != ')');
                            break block23;
lbl-1000:
                            // 1 sources

                            {
                                ++last;
lbl64:
                                // 2 sources

                                ** while (last < l && ch[last] != ' ')
                            }
                        }
                        if (ind >= last || last > l) break block24;
                        if (!list) break block25;
                        v = new Vector<String>();
                        if (ch[ind] == ' ') {
                            ++ind;
                        }
                        delim = (val = new String(ch, ind, last - ind - 1)).indexOf(39) >= 0 ? "'" : " ";
                        st = new StringTokenizer(val, delim);
                        if (true) ** GOTO lbl90
                    }
                    val = new String(ch, ind, last - ind);
                    if (s.equals("NAME")) {
                        this.name = val;
                    } else if (s.equals("DESC")) {
                        this.description = val;
                    } else {
                        this.properties.put(s, val);
                    }
                    if (quoted) {
                        ++last;
                    }
                    break block24;
                    do {
                        if ((tok = st.nextToken().trim()).length() <= 0 || tok.equals("$")) continue;
                        v.addElement(tok);
lbl90:
                        // 3 sources

                    } while (st.hasMoreTokens());
                    this.properties.put(s, v);
                }
                ind = last + 1;
lbl95:
                // 3 sources

            } while (ind < l);
        }
        vals = this.getQualifier("NAME");
        if (vals != null && vals.length > 0) {
            this.name = vals[0];
            if (vals.length > 1) {
                this.aliases = new String[vals.length - 1];
                System.arraycopy(vals, 1, this.aliases, 0, this.aliases.length);
            }
        }
    }

    public String getValue() {
        return this.getValue(false);
    }

    String getValue(boolean quotingBug) {
        return null;
    }

    String getValuePrefix() {
        String s = "( " + this.oid + ' ';
        if (this.name != null && this.name.length() > 0) {
            s = String.valueOf(s) + "NAME ";
            if (this.aliases != null) {
                s = String.valueOf(s) + "( '" + this.name + "' ";
                int i = 0;
                while (i < this.aliases.length) {
                    s = String.valueOf(s) + '\'' + this.aliases[i] + "' ";
                    ++i;
                }
                s = String.valueOf(s) + ") ";
            } else {
                s = String.valueOf(s) + '\'' + this.name + "' ";
            }
        }
        if (this.description != null) {
            s = String.valueOf(s) + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            s = String.valueOf(s) + "OBSOLETE ";
        }
        return s;
    }

    protected String getOptionalValues(String[] names) {
        String s = "";
        int i = 0;
        while (i < names.length) {
            String[] vals = this.getQualifier(names[i]);
            if (vals != null && vals.length > 0) {
                s = String.valueOf(s) + names[i] + ' ' + vals[0];
            }
            ++i;
        }
        return s;
    }

    protected String getCustomValues() {
        String s = "";
        Enumeration en = this.properties.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith("X-")) continue;
            s = String.valueOf(s) + this.getValue(key, true, false) + ' ';
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    String getValue(String key, boolean doQuote, boolean doDollar) {
        String s = "";
        Object o = this.properties.get(key);
        if (o == null) {
            return s;
        }
        if (o instanceof String) {
            if (((String)o).length() > 0) {
                s = String.valueOf(s) + key + ' ';
                if (doQuote) {
                    s = String.valueOf(s) + '\'';
                }
                s = String.valueOf(s) + (String)o;
                if (doQuote) {
                    s = String.valueOf(s) + '\'';
                }
            }
        } else {
            s = String.valueOf(s) + key + " ( ";
            Vector v = (Vector)o;
            int i = 0;
            while (i < v.size()) {
                if (doQuote) {
                    s = String.valueOf(s) + '\'';
                }
                s = String.valueOf(s) + (String)v.elementAt(i);
                if (doQuote) {
                    s = String.valueOf(s) + '\'';
                }
                s = String.valueOf(s) + ' ';
                if (doDollar && i < v.size() - 1) {
                    s = String.valueOf(s) + "$ ";
                }
                ++i;
            }
            s = String.valueOf(s) + ')';
        }
        return s;
    }

    String getValue(String key, boolean doQuote) {
        return this.getValue(key, doQuote, true);
    }

    public void setQualifier(String name, String value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (value != null) {
            this.properties.put(name, value);
        } else {
            this.properties.remove(name);
        }
    }

    public void setQualifier(String name, String[] values) {
        if (values == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < values.length) {
            v.addElement(values[i]);
            ++i;
        }
        this.properties.put(name, v);
    }

    public String[] getQualifier(String name) {
        if (this.properties == null) {
            return null;
        }
        Object o = this.properties.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            Object[] vals = new String[v.size()];
            v.copyInto(vals);
            return vals;
        }
        String s = (String)o;
        if (s.length() < 1) {
            return new String[0];
        }
        return new String[]{s};
    }

    public Enumeration getQualifierNames() {
        return this.properties.keys();
    }

    public String[] getAliases() {
        return this.aliases;
    }

    String getQualifierString(String[] ignore) {
        Hashtable<String, String> toIgnore = null;
        if (ignore != null) {
            toIgnore = new Hashtable<String, String>();
            int i = 0;
            while (i < ignore.length) {
                toIgnore.put(ignore[i], ignore[i]);
                ++i;
            }
        }
        String s = "";
        Enumeration en = this.getQualifierNames();
        while (en.hasMoreElements()) {
            String qualifier = (String)en.nextElement();
            if (toIgnore != null && toIgnore.containsKey(qualifier)) continue;
            s = String.valueOf(s) + "; " + qualifier;
            String[] vals = this.getQualifier(qualifier);
            if (vals == null) {
                s = String.valueOf(s) + ' ';
                continue;
            }
            s = String.valueOf(s) + ": ";
            int i = 0;
            while (i < vals.length) {
                s = String.valueOf(s) + vals[i] + ' ';
                ++i;
            }
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == ' ') {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    String getAliasString() {
        if (this.aliases != null) {
            String s = "; aliases:";
            int i = 0;
            while (i < this.aliases.length) {
                s = String.valueOf(s) + ' ' + this.aliases[i];
                ++i;
            }
            return s;
        }
        return "";
    }
}

