/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPRebind;

public class LDAPSearchConstraints
extends LDAPConstraints
implements Cloneable {
    public static final int REFERRAL_ERROR_CONTINUE = 0;
    public static final int REFERRAL_ERROR_EXCEPTION = 1;
    private int deref;
    private int maxRes;
    private int batch;
    private int serverTimeLimit;
    private int maxBacklog = 100;
    private int referralErrors = 0;

    public LDAPSearchConstraints() {
        this.deref = 0;
        this.maxRes = 1000;
        this.batch = 1;
        this.serverTimeLimit = 0;
    }

    public LDAPSearchConstraints(int msLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebind_proc, int hop_limit) {
        super(msLimit, doReferrals, rebind_proc, hop_limit);
        this.deref = dereference;
        this.maxRes = maxResults;
        this.batch = batchSize;
    }

    public LDAPSearchConstraints(int msLimit, int timeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPRebind rebind_proc, int hop_limit) {
        super(msLimit, doReferrals, rebind_proc, hop_limit);
        this.serverTimeLimit = timeLimit;
        this.deref = dereference;
        this.maxRes = maxResults;
        this.batch = batchSize;
    }

    public LDAPSearchConstraints(int msLimit, int timeLimit, int dereference, int maxResults, boolean doReferrals, int batchSize, LDAPBind bind_proc, int hop_limit) {
        super(msLimit, doReferrals, bind_proc, hop_limit);
        this.serverTimeLimit = timeLimit;
        this.deref = dereference;
        this.maxRes = maxResults;
        this.batch = batchSize;
    }

    public int getServerTimeLimit() {
        return this.serverTimeLimit;
    }

    public int getDereference() {
        return this.deref;
    }

    public int getMaxResults() {
        return this.maxRes;
    }

    public int getBatchSize() {
        return this.batch;
    }

    public void setServerTimeLimit(int limit) {
        this.serverTimeLimit = limit;
    }

    public void setDereference(int dereference) {
        this.deref = dereference;
    }

    public void setMaxResults(int maxResults) {
        this.maxRes = maxResults;
    }

    public void setBatchSize(int batchSize) {
        this.batch = batchSize;
    }

    public void setMaxBacklog(int backlog) {
        this.maxBacklog = backlog;
    }

    public int getMaxBacklog() {
        return this.maxBacklog;
    }

    public int getReferralErrors() {
        return this.referralErrors;
    }

    public void setReferralErrors(int errorBehavior) {
        if (errorBehavior != 0 && errorBehavior != 1) {
            throw new IllegalArgumentException("Invalid error behavior: " + errorBehavior);
        }
        this.referralErrors = errorBehavior;
    }

    public Object clone() {
        LDAPSearchConstraints o = (LDAPSearchConstraints)super.clone();
        return o;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LDAPSearchConstraints {");
        sb.append(String.valueOf(super.toString()) + ' ');
        sb.append("size limit " + this.maxRes + ", ");
        sb.append("server time limit " + this.serverTimeLimit + ", ");
        sb.append("aliases " + this.deref + ", ");
        sb.append("batch size " + this.batch + ", ");
        sb.append("max backlog " + this.maxBacklog + ", ");
        sb.append("referralErrors " + this.referralErrors);
        sb.append('}');
        return sb.toString();
    }
}

