/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;

public class LDAPSearchResults
implements Enumeration,
Serializable {
    static final long serialVersionUID = -501692208613904825L;
    private Vector entries = null;
    private LDAPSearchListener resultSource;
    private boolean searchComplete = true;
    private LDAPConnection connectionToClose = null;
    private LDAPConnection currConn;
    private boolean persistentSearch = false;
    private LDAPSearchConstraints currCons;
    private String currBase;
    private int currScope;
    private String currFilter;
    private String[] currAttrs;
    private boolean currAttrsOnly;
    private Vector referralResults = new Vector();
    private Vector exceptions;
    private int msgID = -1;
    private boolean firstResult = false;

    public LDAPSearchResults() {
        this.entries = new Vector();
        this.currCons = new LDAPSearchConstraints();
    }

    LDAPSearchResults(LDAPConnection conn, LDAPSearchConstraints cons, String base, int scope, String filter, String[] attrs, boolean attrsOnly) {
        this();
        this.currConn = conn;
        this.currCons = cons;
        this.currBase = base;
        this.currScope = scope;
        this.currFilter = filter;
        this.currAttrs = attrs;
        this.currAttrsOnly = attrsOnly;
    }

    LDAPSearchResults(Vector v) {
        this();
        this.entries = (Vector)v.clone();
        if (this.entries != null && this.entries.size() >= 1) {
            this.entries.removeElementAt(0);
        }
    }

    LDAPSearchResults(Vector v, LDAPConnection conn, LDAPSearchConstraints cons, String base, int scope, String filter, String[] attrs, boolean attrsOnly) {
        this(v);
        this.currConn = conn;
        this.currCons = cons;
        this.currBase = base;
        this.currScope = scope;
        this.currFilter = filter;
        this.currAttrs = attrs;
        this.currAttrsOnly = attrsOnly;
    }

    void add(LDAPMessage msg) {
        String[] urls;
        if (msg instanceof LDAPSearchResult) {
            this.entries.addElement(((LDAPSearchResult)msg).getEntry());
        } else if (msg instanceof LDAPSearchResultReference && (urls = ((LDAPSearchResultReference)msg).getUrls()) != null) {
            if (this.exceptions == null) {
                this.exceptions = new Vector();
            }
            this.exceptions.addElement(new LDAPReferralException(null, 0, urls));
        }
    }

    void add(LDAPException e) {
        if (this.exceptions == null) {
            this.exceptions = new Vector();
        }
        this.exceptions.addElement(e);
    }

    void associate(LDAPSearchListener l) {
        this.resultSource = l;
        this.searchComplete = false;
    }

    void associatePersistentSearch(LDAPSearchListener l) {
        this.resultSource = l;
        this.persistentSearch = true;
        this.searchComplete = false;
        this.firstResult = true;
    }

    void addReferralEntries(LDAPSearchResults res) {
        this.referralResults.addElement(res);
    }

    void closeOnCompletion(LDAPConnection toClose) {
        if (this.searchComplete) {
            try {
                toClose.disconnect();
            }
            catch (LDAPException lDAPException) {}
        } else {
            this.connectionToClose = toClose;
        }
    }

    void quicksort(LDAPEntry[] toSort, LDAPEntryComparator compare, int low, int high) {
        if (low >= high) {
            return;
        }
        LDAPEntry pivot = toSort[low];
        int slow = low - 1;
        int shigh = high + 1;
        while (true) {
            if (compare.isGreater(toSort[--shigh], pivot)) {
                continue;
            }
            while (compare.isGreater(pivot, toSort[++slow])) {
            }
            if (slow >= shigh) break;
            LDAPEntry temp = toSort[slow];
            toSort[slow] = toSort[shigh];
            toSort[shigh] = temp;
        }
        this.quicksort(toSort, compare, low, shigh);
        this.quicksort(toSort, compare, shigh + 1, high);
    }

    void setMsgID(int msgID) {
        this.msgID = msgID;
    }

    public LDAPControl[] getResponseControls() {
        return this.currConn.getResponseControls(this.msgID);
    }

    public synchronized void sort(LDAPEntryComparator compare) {
        int numEntries;
        while (!this.searchComplete) {
            this.fetchResult();
        }
        if (this.currCons.getReferrals()) {
            while (this.referralResults.size() > 0) {
                Object obj = null;
                obj = this.nextReferralElement();
                if (obj == null) continue;
                if (obj instanceof LDAPException) {
                    this.add((LDAPException)obj);
                    continue;
                }
                this.entries.addElement(obj);
            }
        }
        if ((numEntries = this.entries.size()) <= 0) {
            return;
        }
        Object[] toSort = new LDAPEntry[numEntries];
        this.entries.copyInto(toSort);
        if (toSort.length > 1) {
            this.quicksort((LDAPEntry[])toSort, compare, 0, numEntries - 1);
        }
        this.entries.removeAllElements();
        int i = 0;
        while (i < numEntries) {
            this.entries.addElement(toSort[i]);
            ++i;
        }
    }

    public LDAPEntry next() throws LDAPException {
        Object o = this.nextElement();
        if (o instanceof LDAPReferralException || o instanceof LDAPException) {
            throw (LDAPException)o;
        }
        if (o instanceof LDAPEntry) {
            return (LDAPEntry)o;
        }
        return null;
    }

    public Object nextElement() {
        if (this.entries.size() > 0) {
            Object obj = this.entries.elementAt(0);
            this.entries.removeElementAt(0);
            return obj;
        }
        if (this.referralResults.size() > 0) {
            return this.nextReferralElement();
        }
        if (this.exceptions != null && this.exceptions.size() > 0) {
            Object obj = this.exceptions.elementAt(0);
            this.exceptions.removeElementAt(0);
            return obj;
        }
        return null;
    }

    Object nextReferralElement() {
        LDAPSearchResults res = (LDAPSearchResults)this.referralResults.elementAt(0);
        if (!res.persistentSearch && res.hasMoreElements() || res.persistentSearch) {
            Object obj = res.nextElement();
            if (obj != null) {
                return obj;
            }
            if (obj == null || !res.hasMoreElements()) {
                this.referralResults.removeElementAt(0);
            }
        } else {
            this.referralResults.removeElementAt(0);
        }
        return null;
    }

    public boolean hasMoreElements() {
        while (this.entries.size() == 0 && !this.searchComplete) {
            this.fetchResult();
        }
        if (this.entries.size() == 0 && (this.exceptions == null || this.exceptions.size() == 0)) {
            while (this.referralResults.size() > 0) {
                LDAPSearchResults res = (LDAPSearchResults)this.referralResults.elementAt(0);
                if (res.hasMoreElements()) {
                    return true;
                }
                this.referralResults.removeElementAt(0);
            }
        }
        return this.entries.size() > 0 || this.exceptions != null && this.exceptions.size() > 0;
    }

    public int getCount() {
        while (this.resultSource != null && this.resultSource.getMessageCount() > 0) {
            this.fetchResult();
        }
        int count = this.entries.size();
        int i = 0;
        while (i < this.referralResults.size()) {
            LDAPSearchResults res = (LDAPSearchResults)this.referralResults.elementAt(i);
            count += res.getCount();
            ++i;
        }
        if (this.exceptions != null) {
            count += this.exceptions.size();
        }
        return count;
    }

    int getMessageID() {
        if (this.resultSource == null) {
            return -1;
        }
        return this.resultSource.getMessageID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void fetchResult() {
        if (this.resultSource == null) return;
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            if (this.searchComplete || this.firstResult) {
                this.firstResult = false;
                return;
            }
            LDAPMessage msg = null;
            try {
                msg = this.resultSource.nextMessage();
            }
            catch (LDAPException e) {
                this.add(e);
                this.currConn.releaseSearchListener(this.resultSource);
                this.searchComplete = true;
                return;
            }
            if (msg == null) {
                this.searchComplete = true;
                this.currConn.releaseSearchListener(this.resultSource);
                return;
            }
            if (msg instanceof LDAPResponse) {
                try {
                    try {
                        this.currConn.checkSearchMsg(this, msg, this.currCons, this.currBase, this.currScope, this.currFilter, this.currAttrs, this.currAttrsOnly);
                    }
                    catch (LDAPException e) {
                        this.add(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.currConn.releaseSearchListener(this.resultSource);
                    throw throwable;
                }
                {
                    Object var4_9 = null;
                    this.currConn.releaseSearchListener(this.resultSource);
                    this.searchComplete = true;
                    if (this.connectionToClose == null) return;
                }
                try {
                    this.connectionToClose.disconnect();
                }
                catch (LDAPException e) {
                    // empty catch block
                }
                this.connectionToClose = null;
                return;
            }
            try {
                this.currConn.checkSearchMsg(this, msg, this.currCons, this.currBase, this.currScope, this.currFilter, this.currAttrs, this.currAttrsOnly);
            }
            catch (LDAPException e) {
                this.add(e);
            }
            return;
        }
    }
}

