/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPSocketFactory;

public class LDAPUrl
implements Serializable {
    static final long serialVersionUID = -3245440798565713641L;
    public static String defaultFilter = "(objectClass=*)";
    private String m_hostName;
    private int m_portNumber;
    private String m_DN;
    private Vector m_attributes;
    private int m_scope;
    private String m_filter;
    private String m_URL;
    private boolean m_secure;
    private static LDAPSocketFactory m_factory;
    public static final int DEFAULT_SECURE_PORT = 636;

    public LDAPUrl(String url) throws MalformedURLException {
        this.m_attributes = null;
        this.m_scope = 0;
        this.m_filter = defaultFilter;
        this.m_URL = url;
        this.parseUrl(url);
    }

    private void parseUrl(String url) throws MalformedURLException {
        String currentToken;
        StringTokenizer urlParser = new StringTokenizer(url, ":/?", true);
        String str = null;
        try {
            currentToken = urlParser.nextToken();
            if (currentToken.equalsIgnoreCase("LDAPS")) {
                this.m_secure = true;
            } else if (!currentToken.equalsIgnoreCase("LDAP")) {
                throw new MalformedURLException();
            }
            currentToken = urlParser.nextToken();
            if (!currentToken.equals(":")) {
                throw new MalformedURLException();
            }
            currentToken = urlParser.nextToken();
            if (!currentToken.equals("/")) {
                throw new MalformedURLException();
            }
            currentToken = urlParser.nextToken();
            if (!currentToken.equals("/")) {
                throw new MalformedURLException();
            }
            currentToken = urlParser.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new MalformedURLException();
        }
        if (currentToken.equals("/")) {
            this.m_hostName = null;
            this.m_portNumber = this.m_secure ? 636 : 389;
        } else {
            if (currentToken.equals(":")) {
                throw new MalformedURLException("No hostname");
            }
            if (currentToken.equals("?")) {
                throw new MalformedURLException("No host[:port]");
            }
            this.m_hostName = currentToken;
            if (urlParser.countTokens() == 0) {
                this.m_portNumber = this.m_secure ? 636 : 389;
                return;
            }
            currentToken = urlParser.nextToken();
            if (currentToken.equals(":")) {
                try {
                    this.m_portNumber = Integer.parseInt(urlParser.nextToken());
                }
                catch (NumberFormatException nf) {
                    throw new MalformedURLException("Port not a number");
                }
                catch (NoSuchElementException ex) {
                    throw new MalformedURLException("No port number");
                }
                if (urlParser.countTokens() == 0) {
                    return;
                }
                if (!urlParser.nextToken().equals("/")) {
                    throw new MalformedURLException();
                }
            } else if (currentToken.equals("/")) {
                this.m_portNumber = this.m_secure ? 636 : 389;
            } else {
                throw new MalformedURLException();
            }
        }
        if (!urlParser.hasMoreTokens()) {
            return;
        }
        this.m_DN = LDAPUrl.decode(this.readNextConstruct(urlParser));
        if (this.m_DN.equals("?")) {
            this.m_DN = "";
        } else if (this.m_DN.equals("/")) {
            throw new MalformedURLException();
        }
        if (!urlParser.hasMoreTokens()) {
            return;
        }
        str = this.readNextConstruct(urlParser);
        if (!str.equals("?")) {
            StringTokenizer attributeParser = new StringTokenizer(LDAPUrl.decode(str), ", ");
            this.m_attributes = new Vector();
            while (attributeParser.hasMoreTokens()) {
                this.m_attributes.addElement(attributeParser.nextToken());
            }
        }
        if (!urlParser.hasMoreTokens()) {
            return;
        }
        str = this.readNextConstruct(urlParser);
        if (!str.equals("?")) {
            this.m_scope = this.getScope(str);
            if (this.m_scope < 0) {
                throw new MalformedURLException("Bad scope:" + str);
            }
        }
        if (!urlParser.hasMoreTokens()) {
            return;
        }
        str = this.readNextConstruct(urlParser);
        this.m_filter = LDAPUrl.decode(str);
        this.checkBalancedParentheses(this.m_filter);
        if (!this.m_filter.startsWith("(") && !this.m_filter.endsWith(")")) {
            this.m_filter = "(" + this.m_filter + ")";
        }
        if (urlParser.hasMoreTokens()) {
            throw new MalformedURLException();
        }
    }

    private void checkBalancedParentheses(String filter) throws MalformedURLException {
        int parenCnt = 0;
        StringTokenizer filterParser = new StringTokenizer(filter, "()", true);
        while (filterParser.hasMoreElements()) {
            String token = filterParser.nextToken();
            if (token.equals("(")) {
                ++parenCnt;
                continue;
            }
            if (!token.equals(")") || --parenCnt >= 0) continue;
            throw new MalformedURLException("Unbalanced filter parentheses");
        }
        if (parenCnt != 0) {
            throw new MalformedURLException("Unbalanced filter parentheses");
        }
    }

    public LDAPUrl(String host, int port, String DN2) {
        this.initialize(host, port, DN2, null, 0, defaultFilter, false);
    }

    public LDAPUrl(String host, int port, String DN2, String[] attributes, int scope, String filter) {
        this(host, port, DN2, attributes, scope, filter, false);
    }

    public LDAPUrl(String host, int port, String DN2, Enumeration attributes, int scope, String filter) {
        this.initialize(host, port, DN2, attributes, scope, filter, false);
    }

    public LDAPUrl(String host, int port, String DN2, String[] attributes, int scope, String filter, boolean secure) {
        if (attributes != null) {
            Vector<String> list = new Vector<String>();
            int k = 0;
            while (k < attributes.length) {
                list.addElement(attributes[k]);
                ++k;
            }
            this.initialize(host, port, DN2, list.elements(), scope, filter, secure);
        } else {
            this.initialize(host, port, DN2, null, scope, filter, secure);
        }
    }

    private void initialize(String host, int port, String DN2, Enumeration attributes, int scope, String filter, boolean secure) {
        this.m_hostName = host;
        this.m_DN = DN2;
        this.m_portNumber = port;
        this.m_filter = filter != null ? filter : defaultFilter;
        this.m_scope = scope;
        this.m_secure = secure;
        if (attributes != null) {
            this.m_attributes = new Vector();
            while (attributes.hasMoreElements()) {
                this.m_attributes.addElement(attributes.nextElement());
            }
        } else {
            this.m_attributes = null;
        }
        StringBuffer url = new StringBuffer(secure ? "ldaps://" : "ldap://");
        if (host != null) {
            url.append(host);
            url.append(':');
            url.append(String.valueOf(port));
        }
        url.append('/');
        url.append(LDAPUrl.encode(DN2));
        if (attributes != null) {
            url.append('?');
            Enumeration attrList = this.m_attributes.elements();
            boolean firstElement = true;
            while (attrList.hasMoreElements()) {
                if (!firstElement) {
                    url.append(',');
                } else {
                    firstElement = false;
                }
                url.append((String)attrList.nextElement());
            }
        }
        if (filter != null) {
            if (attributes == null) {
                url.append('?');
            }
            url.append('?');
            switch (scope) {
                default: {
                    url.append("base");
                    break;
                }
                case 1: {
                    url.append("one");
                    break;
                }
                case 2: {
                    url.append("sub");
                }
            }
            url.append('?');
            url.append(filter);
        }
        this.m_URL = url.toString();
    }

    public String getHost() {
        return this.m_hostName;
    }

    public int getPort() {
        return this.m_portNumber;
    }

    public String getDN() {
        return this.m_DN;
    }

    String getServerUrl() {
        return String.valueOf(this.m_secure ? "ldaps://" : "ldap://") + this.m_hostName + ":" + this.m_portNumber;
    }

    public Enumeration getAttributes() {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.elements();
    }

    public String[] getAttributeArray() {
        if (this.m_attributes == null) {
            return null;
        }
        String[] attrNames = new String[this.m_attributes.size()];
        Enumeration attrs = this.getAttributes();
        int i = 0;
        while (attrs.hasMoreElements()) {
            attrNames[i++] = (String)attrs.nextElement();
        }
        return attrNames;
    }

    public int getScope() {
        return this.m_scope;
    }

    private int getScope(String str) {
        int s = -1;
        if (str.equalsIgnoreCase("base")) {
            s = 0;
        } else if (str.equalsIgnoreCase("one")) {
            s = 1;
        } else if (str.equalsIgnoreCase("sub")) {
            s = 2;
        }
        return s;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public String getUrl() {
        return this.m_URL;
    }

    public boolean isSecure() {
        return this.m_secure;
    }

    public static LDAPSocketFactory getSocketFactory() {
        if (m_factory == null) {
            Class<?> c2;
            try {
                c2 = Class.forName("netscape.ldap.factory.JSSSocketFactory");
                m_factory = (LDAPSocketFactory)c2.newInstance();
            }
            catch (Throwable c2) {
                // empty catch block
            }
            if (m_factory != null) {
                return m_factory;
            }
            try {
                c2 = Class.forName("netscape.ldap.factory.JSSESocketFactory");
                m_factory = (LDAPSocketFactory)c2.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return m_factory;
    }

    public static void setSocketFactory(LDAPSocketFactory factory) {
        m_factory = factory;
    }

    private String readNextConstruct(StringTokenizer parser) throws MalformedURLException {
        try {
            if (parser.hasMoreTokens()) {
                String delim;
                String tkn = parser.nextToken();
                if (tkn.equals("?")) {
                    return tkn;
                }
                if (parser.hasMoreTokens() && !(delim = parser.nextToken()).equals("?")) {
                    throw new MalformedURLException();
                }
                return tkn;
            }
        }
        catch (NoSuchElementException e) {
            throw new MalformedURLException();
        }
        return null;
    }

    private static int hexValue(char hexChar) throws MalformedURLException {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 'a' && hexChar <= 'f') {
            return hexChar - 97 + 10;
        }
        throw new MalformedURLException();
    }

    private static char hexChar(int hexValue) {
        if (hexValue < 0 || hexValue > 15) {
            return 'x';
        }
        if (hexValue < 10) {
            return (char)(hexValue + 48);
        }
        return (char)(hexValue - 10 + 97);
    }

    public static String decode(String URLEncoded) throws MalformedURLException {
        StringBuffer decoded = new StringBuffer(URLEncoded);
        int srcPos = 0;
        int dstPos = 0;
        try {
            while (srcPos < decoded.length()) {
                if (decoded.charAt(srcPos) != '%') {
                    if (srcPos != dstPos) {
                        decoded.setCharAt(dstPos, decoded.charAt(srcPos));
                    }
                    ++srcPos;
                    ++dstPos;
                    continue;
                }
                decoded.setCharAt(dstPos, (char)(LDAPUrl.hexValue(decoded.charAt(srcPos + 1)) << 4 | LDAPUrl.hexValue(decoded.charAt(srcPos + 2))));
                ++dstPos;
                srcPos += 3;
            }
        }
        catch (StringIndexOutOfBoundsException sioob) {
            throw new MalformedURLException();
        }
        decoded.setLength(dstPos);
        return decoded.toString();
    }

    public static String encode(String toEncode) {
        StringBuffer encoded = new StringBuffer(toEncode.length() + 10);
        int currPos = 0;
        while (currPos < toEncode.length()) {
            char currChar = toEncode.charAt(currPos);
            if (currChar >= 'a' && currChar <= 'z' || currChar >= 'A' && currChar <= 'Z' || currChar >= '0' && currChar <= '9' || "$-_.+!*'(),".indexOf(currChar) > 0) {
                encoded.append(currChar);
            } else {
                encoded.append("%");
                encoded.append(LDAPUrl.hexChar((currChar & 0xF0) >> 4));
                encoded.append(LDAPUrl.hexChar(currChar & 0xF));
            }
            ++currPos;
        }
        return encoded.toString();
    }

    public String toString() {
        return this.getUrl();
    }

    public boolean equals(LDAPUrl url) {
        if (this.getHost() == null ? url.getHost() != null : !this.getHost().equals(url.getHost())) {
            return false;
        }
        if (this.getPort() != url.getPort()) {
            return false;
        }
        if (this.getDN() == null ? url.getDN() != null : !this.getDN().equals(url.getDN())) {
            return false;
        }
        if (this.getFilter() == null ? url.getFilter() != null : !this.getFilter().equals(url.getFilter())) {
            return false;
        }
        if (this.getScope() != url.getScope()) {
            return false;
        }
        if (this.m_attributes == null) {
            if (url.m_attributes != null) {
                return false;
            }
        } else {
            if (this.m_attributes.size() != url.m_attributes.size()) {
                return false;
            }
            int i = 0;
            while (i < this.m_attributes.size()) {
                if (this.m_attributes.elementAt(i) != url.m_attributes.elementAt(i)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

