/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPSortControl
extends LDAPControl {
    public static final String SORTREQUEST = "1.2.840.113556.1.4.473";
    public static final String SORTRESPONSE = "1.2.840.113556.1.4.474";
    private String m_failedAttribute = null;
    private int m_resultCode = 0;
    private LDAPSortKey[] m_keys;

    public LDAPSortControl(String oid, boolean critical, byte[] value) throws LDAPException, IOException {
        super(oid, critical, value);
        if (!oid.equals(SORTRESPONSE)) {
            throw new LDAPException("oid must be LDAPSortControl.SORTRESPONSE", 89);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(value);
        BERSequence ber = new BERSequence();
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] nRead = new int[1];
        BERSequence seq = (BERSequence)BERElement.getElement(decoder, inStream, nRead);
        this.m_resultCode = ((BEREnumerated)seq.elementAt(0)).getValue();
        if (seq.size() == 1) {
            return;
        }
        BEROctetString t = (BEROctetString)seq.elementAt(1);
        try {
            this.m_failedAttribute = new String(t.getValue(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public String getFailedAttribute() {
        return this.m_failedAttribute;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    public LDAPSortControl(LDAPSortKey key, boolean critical) {
        super(SORTREQUEST, critical, null);
        LDAPSortKey[] keys = new LDAPSortKey[]{key};
        this.m_keys = keys;
        this.m_value = this.createSortSpecification(keys);
    }

    public LDAPSortControl(LDAPSortKey[] keys, boolean critical) {
        super(SORTREQUEST, critical, null);
        this.m_keys = keys;
        this.m_value = this.createSortSpecification(keys);
    }

    public static String parseResponse(LDAPControl[] controls, int[] results) {
        String attr = null;
        LDAPControl sort = null;
        int i = 0;
        while (controls != null && i < controls.length) {
            if (controls[i].getID().equals(SORTRESPONSE)) {
                sort = controls[i];
                break;
            }
            ++i;
        }
        if (sort != null) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(sort.getValue());
            BERSequence ber = new BERSequence();
            JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
            int[] nRead = new int[]{0};
            try {
                BERSequence seq = (BERSequence)BERElement.getElement(decoder, inStream, nRead);
                int result = ((BEREnumerated)seq.elementAt(0)).getValue();
                if (results != null && results.length > 0) {
                    results[0] = result;
                }
                BEROctetString t = (BEROctetString)seq.elementAt(1);
                attr = new String(t.getValue(), "UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attr;
    }

    private byte[] createSortSpecification(LDAPSortKey[] keys) {
        BERSequence ber = new BERSequence();
        int i = 0;
        while (i < keys.length) {
            BERSequence seq = new BERSequence();
            seq.addElement(new BEROctetString(keys[i].getKey()));
            if (keys[i].getMatchRule() != null) {
                seq.addElement(new BERTag(128, new BEROctetString(keys[i].getMatchRule()), true));
            }
            if (keys[i].getReverse()) {
                seq.addElement(new BERTag(129, new BEREnumerated(129), true));
            }
            ber.addElement(seq);
            ++i;
        }
        return this.flattenBER(ber);
    }

    public String toString() {
        return this.getID() == SORTREQUEST ? this.reqToString() : this.rspToString();
    }

    String reqToString() {
        StringBuffer sb = new StringBuffer("{SortCtrl:");
        sb.append(" isCritical=");
        sb.append(this.isCritical());
        sb.append(" ");
        int i = 0;
        while (i < this.m_keys.length) {
            sb.append(this.m_keys[i]);
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    String rspToString() {
        StringBuffer sb = new StringBuffer("{SortResponseCtrl:");
        sb.append(" isCritical=");
        sb.append(this.isCritical());
        if (this.m_failedAttribute != null) {
            sb.append(" failedAttr=");
            sb.append(this.m_failedAttribute);
        }
        sb.append(" resultCode=");
        sb.append(this.m_resultCode);
        sb.append("}");
        return sb.toString();
    }
}

