/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPVirtualListResponse
extends LDAPControl {
    public static final String VIRTUALLISTRESPONSE = "2.16.840.1.113730.3.4.10";
    private int m_firstPosition = 0;
    private int m_contentCount = 0;
    private int m_resultCode = -1;
    private String m_context = null;

    LDAPVirtualListResponse() {
        super(VIRTUALLISTRESPONSE, true, null);
    }

    public LDAPVirtualListResponse(String oid, boolean critical, byte[] value) throws LDAPException {
        super(VIRTUALLISTRESPONSE, critical, value);
        if (!oid.equals(VIRTUALLISTRESPONSE)) {
            throw new LDAPException("oid must be LDAPVirtualListResponse.VIRTUALLISTRESPONSE", 89);
        }
        this.parseResponse();
    }

    public LDAPVirtualListResponse(byte[] value) {
        super(VIRTUALLISTRESPONSE, true, null);
        this.m_value = value;
        this.parseResponse();
    }

    public int getContentCount() {
        return this.m_contentCount;
    }

    public int getFirstPosition() {
        return this.m_firstPosition;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    public String getContext() {
        return this.m_context;
    }

    private void parseResponse() {
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.getValue());
        BERSequence ber = new BERSequence();
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] nRead = new int[]{0};
        try {
            BERSequence seq = (BERSequence)BERElement.getElement(decoder, inStream, nRead);
            this.m_firstPosition = ((BERInteger)seq.elementAt(0)).getValue();
            this.m_contentCount = ((BERInteger)seq.elementAt(1)).getValue();
            this.m_resultCode = ((BEREnumerated)seq.elementAt(2)).getValue();
            if (seq.size() > 3) {
                BEROctetString str = (BEROctetString)seq.elementAt(3);
                this.m_context = new String(str.getValue(), "UTF8");
            }
        }
        catch (Exception x) {
            this.m_resultCode = -1;
            this.m_contentCount = -1;
            this.m_firstPosition = -1;
            this.m_context = null;
        }
    }

    public static LDAPVirtualListResponse parseResponse(LDAPControl[] controls) {
        LDAPVirtualListResponse con = null;
        int i = 0;
        while (controls != null && i < controls.length) {
            if (controls[i].getID().equals(VIRTUALLISTRESPONSE)) {
                con = new LDAPVirtualListResponse(controls[i].getValue());
                con.parseResponse();
                break;
            }
            ++i;
        }
        if (con != null) {
            super.parseResponse();
        }
        return con;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{VirtListResponseCtrl:");
        sb.append(" isCritical=");
        sb.append(this.isCritical());
        sb.append(" firstPosition=");
        sb.append(this.m_firstPosition);
        sb.append(" contentCount=");
        sb.append(this.m_contentCount);
        sb.append(" resultCode=");
        sb.append(this.m_resultCode);
        if (this.m_context != null) {
            sb.append(" conext=");
            sb.append(this.m_context);
        }
        sb.append("}");
        return sb.toString();
    }
}

