/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.StringTokenizer;

public class Ident {
    public String errorMessage;
    public String hostType;
    public String userName;
    public boolean successful;
    public int errorCode;
    public static final int ERR_NO_CONNECT = 1;
    public static final int ERR_TIMEOUT = 2;
    public static final int ERR_PROTOCOL = 3;
    public static final int ERR_PROTOCOL_INCORRECT = 4;
    public static final int connectionTimeout = 10000;

    public Ident(Socket socket) {
        Socket socket2 = null;
        this.successful = false;
        try {
            try {
                socket2 = new Socket(socket.getInetAddress(), 113);
                socket2.setSoTimeout(10000);
                byte[] byArray = (socket.getPort() + " , " + socket.getLocalPort() + "\r\n").getBytes();
                socket2.getOutputStream().write(byArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket2.getInputStream()));
                this.parseResponse(bufferedReader.readLine());
            }
            catch (InterruptedIOException interruptedIOException) {
                this.errorCode = 2;
                this.errorMessage = "Connection to identd timed out.";
            }
            catch (ConnectException connectException) {
                this.errorCode = 1;
                this.errorMessage = "Connection to identd server failed.";
            }
            catch (IOException iOException) {
                this.errorCode = 1;
                this.errorMessage = String.valueOf(String.valueOf(iOException));
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                if (socket2 != null) {
                    socket2.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (socket2 != null) {
                socket2.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void parseResponse(String string) {
        if (string == null) {
            this.errorCode = 4;
            this.errorMessage = "Identd server closed connection.";
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() < 3) {
            this.errorCode = 4;
            this.errorMessage = "Can't parse server response.";
            return;
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().trim().toUpperCase();
        if (string2.equals("USERID") && stringTokenizer.countTokens() >= 2) {
            this.successful = true;
            this.hostType = stringTokenizer.nextToken().trim();
            this.userName = stringTokenizer.nextToken("").substring(1);
        } else if (string2.equals("ERROR")) {
            this.errorCode = 3;
            this.errorMessage = stringTokenizer.nextToken();
        } else {
            this.errorCode = 4;
            System.out.println("Opa!");
            this.errorMessage = "Can't parse server response.";
        }
    }
}

