/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import socks.InetRange;
import socks.ProxyMessage;
import socks.server.Ident;
import socks.server.ServerAuthenticator;
import socks.server.ServerAuthenticatorNone;

public class IdentAuthenticator
extends ServerAuthenticatorNone {
    Vector hosts;
    Vector users;
    String user;

    public IdentAuthenticator() {
        this.hosts = new Vector();
        this.users = new Vector();
    }

    IdentAuthenticator(InputStream inputStream, OutputStream outputStream, String string) {
        super(inputStream, outputStream);
        this.user = string;
    }

    public synchronized void add(InetRange inetRange, Hashtable hashtable) {
        this.hosts.addElement(inetRange);
        this.users.addElement(hashtable);
    }

    public boolean checkRequest(ProxyMessage proxyMessage, Socket socket) {
        if (proxyMessage.version == 5 || this.user == null) {
            return true;
        }
        if (proxyMessage.version != 4) {
            return false;
        }
        return this.user.equals(proxyMessage.user);
    }

    private int getRangeIndex(InetAddress inetAddress) {
        int n = 0;
        Enumeration enumeration = this.hosts.elements();
        while (enumeration.hasMoreElements()) {
            InetRange inetRange = (InetRange)enumeration.nextElement();
            if (inetRange.contains(inetAddress)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ServerAuthenticator startSession(Socket socket) throws IOException {
        int n = this.getRangeIndex(socket.getInetAddress());
        String string = null;
        if (n < 0) {
            return null;
        }
        ServerAuthenticatorNone serverAuthenticatorNone = (ServerAuthenticatorNone)super.startSession(socket);
        if (serverAuthenticatorNone == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)this.users.elementAt(n);
        if (hashtable != null) {
            Ident ident = new Ident(socket);
            if (!ident.successful) {
                return null;
            }
            if (!hashtable.containsKey(ident.userName)) {
                return null;
            }
            string = ident.userName;
        }
        return new IdentAuthenticator(serverAuthenticatorNone.in, serverAuthenticatorNone.out, string);
    }

    public String toString() {
        String string = "";
        int n = 0;
        while (n < this.hosts.size()) {
            string = String.valueOf(string) + "Range:" + this.hosts.elementAt(n) + "\nUsers:" + this.userNames(n) + "\n";
            ++n;
        }
        return string;
    }

    private String userNames(int n) {
        if (this.users.elementAt(n) == null) {
            return "Everybody is permitted.";
        }
        Enumeration enumeration = ((Hashtable)this.users.elementAt(n)).keys();
        if (!enumeration.hasMoreElements()) {
            return "";
        }
        String string = enumeration.nextElement().toString();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + "; " + enumeration.nextElement();
        }
        return string;
    }
}

