#!/bin/bash
CHARS=$(echo $BASH_SOURCE |wc -c)
COUNT=$((CHARS-9))
DIR=$(echo $BASH_SOURCE|cut -c 1-$COUNT)
cd $DIR

if [ $UID -gt 0 ]
then
  ./securitylayer --root-warning-msg
fi

./securitylayer setup $* --h $HOME
exitcode=$?

function checkPWD
{
  if [ ! -e securitylayer ]
  then
    echo "$(PWD) is not the correct directory!"
    exit
 fi 
   
  if [ ! -e version.xml ]
  then
    echo "$(PWD) is not the correct directory!"
    exit
  fi
}

function generate-uninstall-scripts
{
  touch /tmp/its-remove-tdb.sh
  touch /tmp/its-remove-tdb-data.sh
  chmod 700 /tmp/its-remove-tdb.sh
  chmod 700 /tmp/its-remove-tdb-data.sh
  checkPWD
  local scripta="#!/bin/bash\nrm -rf $(pwd)" 
  local scriptb="#!/bin/bash\nrm -rf $(echo ~)/.Signaturumgebung"
  echo -e $scripta>/tmp/its-remove-tdb.sh
  echo -e $scriptb>/tmp/its-remove-tdb-data.sh
}
function remove-scripts
{
  rm -f /tmp/its-remove-tdb-data.sh
  rm -f /tmp/its-remove-tdb.sh
}

#last exit code (from .securitylayer)
if [ $exitcode -eq 16 ]
then
  echo "removing trustDesk basic from your System"
  killall securitylayer
  killall trustDesk
  killall cardaccess
  killall trustDeskApplet
  generate-uninstall-scripts
  /tmp/its-remove-tdb.sh
  remove-scripts
  exit
fi

if [ $exitcode -eq 32 ]
then
  echo "removing trustDesk basic from your System"
  killall securitylayer
  killall trustDesk
  killall cardaccess
  killall trustDeskApplet
  generate-uninstall-scripts
  /tmp/its-remove-tdb-data.sh
  /tmp/its-remove-tdb.sh
  remove-scripts  
  exit
fi

if [ $exitcode -eq 0 ]
then
  if [ ! $SUDO_USER = $USER ] 
  then
    chown -R $SUDO_USER $HOME/.Signaturumgebung
    chown -R $SUDO_USER $HOME/.local/share
    chown -R $SUDO_USER $HOME/.config
  fi
fi

