/* Generated By:JavaCC: Do not edit this line. SACParser.java */
package com.steadystate.css.parser;

import java.io.*;
import java.net.*;
import java.util.*;
import org.w3c.css.sac.*;
import com.steadystate.css.parser.selectors.*;

/**
 * @author David Schweinsberg
 * @version $Release$
 */
public class SACParser implements Parser, SACParserConstants {

    private InputSource _source = null;
    private Locale _locale = null;
    private DocumentHandler _docHandler = null;
    private ErrorHandler _errHandler = null;
    private SelectorFactory _selectorFactory = new SelectorFactoryImpl();
    private ConditionFactory _conditionFactory = new ConditionFactoryImpl();
    private boolean _quiet = true;

    public SACParser() {
        this((CharStream) null);
    }

    public void setLocale(Locale locale) throws CSSException {
        _locale = locale;

        // TODO: Search for requested locale

        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    public void setDocumentHandler(DocumentHandler handler) {
        _docHandler = handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        _selectorFactory = selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        _conditionFactory = conditionFactory;
    }

    public void setErrorHandler(ErrorHandler handler) {
        _errHandler = handler;
    }

    public void parseStyleSheet(InputSource source)
            throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        try {
            styleSheet();
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
    }

    public void parseStyleSheet(String uri) throws CSSException, IOException {
        parseStyleSheet(new InputSource(uri));
    }

    public void parseStyleDeclaration(InputSource source)
            throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        try {
            styleDeclaration();
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
    }

    public void parseRule(InputSource source) throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        try {
            styleSheetRuleSingle();
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
    }

    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    public SelectorList parseSelectors(InputSource source)
            throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        SelectorList sl = null;
        try {
            sl = selectorList();
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
        return sl;
    }

    public SACMediaList parseMedia(InputSource source)
            throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        SACMediaListImpl sml = new SACMediaListImpl();
        try {
            mediaList(sml);
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
        return sml;
    }

    public LexicalUnit parsePropertyValue(InputSource source)
            throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        LexicalUnit lu = null;
        try {
            lu = expr();
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
        return lu;
    }

    public boolean parsePriority(InputSource source)
            throws CSSException, IOException {
        _source = source;
        ReInit(getCharStream(source));
        boolean b = false;
        try {
            b = prio();
        } catch (ParseException e) {
            throw new CSSException(CSSException.SAC_SYNTAX_ERR, e.getMessage(), e);
        }
        return b;
    }

    private CharStream getCharStream(InputSource source)
            throws CSSException, IOException {
        if (source.getCharacterStream() != null) {
                return new ASCII_CharStream(source.getCharacterStream(), 1, 1);
            } else {

            // TODO: Handle other sources
            return null;
        }
    }

    private Locator getLocator() {
        return null;
    }

//
// stylesheet
//  : [ CHARSET_SYM S* STRING S* ';' ]?
//      [S|CDO|CDC]* [ import [S|CDO|CDC]* ]*
//      [ [ ruleset | media | page | font_face ] [S|CDO|CDC]* ]*
//  ;
//
  final public void styleSheet() throws ParseException {
    try {
          _docHandler.startDocument(_source);
      styleSheetRuleList();
      jj_consume_token(0);
    } finally {
        _docHandler.endDocument(_source);
    }
  }

  final public void styleSheetRuleList() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARSET_SYM:
      charsetRule();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
      case CDO:
      case CDC:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        jj_consume_token(S);
        break;
      case CDO:
        jj_consume_token(CDO);
        break;
      case CDC:
        jj_consume_token(CDC);
        break;
      default:
        jj_la1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT_SYM:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      importRule();
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case MEDIA_SYM:
      case FONT_FACE_SYM:
      case ATKEYWORD:
      case IDENT:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IDENT:
        styleRule();
        break;
      case MEDIA_SYM:
        mediaRule();
        break;
      case PAGE_SYM:
        pageRule();
        break;
      case FONT_FACE_SYM:
        fontFaceRule();
        break;
      case ATKEYWORD:
        unknownRule();
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
        case CDO:
        case CDC:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_5;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          jj_consume_token(S);
          break;
        case CDO:
          jj_consume_token(CDO);
          break;
        case CDC:
          jj_consume_token(CDC);
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

//
// This is used by ASTStyleSheet.insertRule to parse a single rule
//
  final public void styleSheetRuleSingle() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHARSET_SYM:
      charsetRule();
      break;
    case IMPORT_SYM:
      importRule();
      break;
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:
    case IDENT:
      styleRule();
      break;
    case MEDIA_SYM:
      mediaRule();
      break;
    case PAGE_SYM:
      pageRule();
      break;
    case FONT_FACE_SYM:
      fontFaceRule();
      break;
    case ATKEYWORD:
      unknownRule();
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void charsetRule() throws ParseException {
  Token t;
    jj_consume_token(CHARSET_SYM);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_6;
      }
      jj_consume_token(S);
    }
    t = jj_consume_token(STRING);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_7;
      }
      jj_consume_token(S);
    }
    jj_consume_token(SEMICOLON);
  }

  final public void unknownRule() throws ParseException {
    Token t;
    String s;
    t = jj_consume_token(ATKEYWORD);
        s = skip();
        _docHandler.ignorableAtRule(s);
  }

//
// import
//   : IMPORT_SYM S*
//     [STRING|URI] S* [ medium [ ',' S* medium]* ]? ';' S*
//   ;
//
  final public void importRule() throws ParseException {
    Token t;
    String s;
    SACMediaListImpl ml = new SACMediaListImpl();
    jj_consume_token(IMPORT_SYM);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_8;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING:
      t = jj_consume_token(STRING);
      break;
    case URI:
      t = jj_consume_token(URI);
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_9;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      mediaList(ml);
      break;
    default:
      jj_la1[16] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
        _docHandler.importStyle(unescape(t.image), ml, null);
  }

//
// media
//   : MEDIA_SYM S* medium [ ',' S* medium ]* '{' S* ruleset* '}' S*
//   ;
//
  final public void mediaRule() throws ParseException {
    boolean start = false;
    SACMediaListImpl ml = new SACMediaListImpl();
    try {
      jj_consume_token(MEDIA_SYM);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_10;
        }
        jj_consume_token(S);
      }
      mediaList(ml);
            start = true;
            _docHandler.startMedia(ml);
      jj_consume_token(LBRACE);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_11;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case ATKEYWORD:
      case IDENT:
        mediaRuleList();
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } finally {
        if (start) {
            _docHandler.endMedia(ml);
        }
    }
  }

  final public void mediaList(SACMediaListImpl ml) throws ParseException {
    String s;
    s = medium();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[20] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_13;
        }
        jj_consume_token(S);
      }
                         ml.add(s);
      s = medium();
    }
      ml.add(s);
  }

  final public void mediaRuleList() throws ParseException {
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case IDENT:
        styleRule();
        break;
      case PAGE_SYM:
        pageRule();
        break;
      case ATKEYWORD:
        unknownRule();
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case COLON:
      case ASTERISK:
      case LSQUARE:
      case HASH:
      case PAGE_SYM:
      case ATKEYWORD:
      case IDENT:
        ;
        break;
      default:
        jj_la1[24] = jj_gen;
        break label_14;
      }
    }
  }

  final public void mediaRuleSingle() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
    case COLON:
    case ASTERISK:
    case LSQUARE:
    case HASH:
    case IDENT:
      styleRule();
      break;
    case PAGE_SYM:
      pageRule();
      break;
    case ATKEYWORD:
      unknownRule();
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

//
// medium
//   : IDENT S*
//   ;
//
  final public String medium() throws ParseException {
  Token t;
    t = jj_consume_token(IDENT);
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[26] = jj_gen;
        break label_16;
      }
      jj_consume_token(S);
    }
                         {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

//
// page
//   : PAGE_SYM S* IDENT? pseudo_page? S*
//     '{' S* declaration [ ';' S* declaration ]* '}' S*
//   ;
//
  final public void pageRule() throws ParseException {
    Token t = null;
    String s = null;
    boolean start = false;
    try {
      jj_consume_token(PAGE_SYM);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_17;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
      case IDENT:
        if (jj_2_1(2)) {
          t = jj_consume_token(IDENT);
          label_18:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case S:
              ;
              break;
            default:
              jj_la1[28] = jj_gen;
              break label_18;
            }
            jj_consume_token(S);
          }
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDENT:
            t = jj_consume_token(IDENT);
            s = pseudoPage();
            label_19:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case S:
                ;
                break;
              default:
                jj_la1[29] = jj_gen;
                break label_19;
              }
              jj_consume_token(S);
            }
            break;
          case COLON:
            s = pseudoPage();
            label_20:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case S:
                ;
                break;
              default:
                jj_la1[30] = jj_gen;
                break label_20;
              }
              jj_consume_token(S);
            }
            break;
          default:
            jj_la1[31] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_21;
        }
        jj_consume_token(S);
      }
            start = true;
            _docHandler.startPage((t != null) ? unescape(t.image) : null, s);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[35] = jj_gen;
          break label_22;
        }
        jj_consume_token(SEMICOLON);
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[36] = jj_gen;
            break label_23;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[37] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } finally {
        if (start) {
            _docHandler.endPage((t != null) ? unescape(t.image) : null, s);
        }
    }
  }

//
// pseudoPage
//   : ':' IDENT
//   ;
//
  final public String pseudoPage() throws ParseException {
  Token t;
    jj_consume_token(COLON);
    t = jj_consume_token(IDENT);
                        {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

//
// font_face
//   : FONT_FACE_SYM S*
//     '{' S* declaration [ ';' S* declaration ]* '}' S*
//   ;
//
  final public void fontFaceRule() throws ParseException {
    boolean start = false;
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_25:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_25;
        }
        jj_consume_token(S);
      }
                            start = true; _docHandler.startFontFace();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_26;
        }
        jj_consume_token(SEMICOLON);
        label_27:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[42] = jj_gen;
            break label_27;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[43] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } finally {
        if (start) {
            _docHandler.endFontFace();
        }
    }
  }

//
// operator
//   : '/' S* | ',' S* |
//   ;
//
  final public LexicalUnit operator(LexicalUnit prev) throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SLASH:
      t = jj_consume_token(SLASH);
      label_28:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_28;
        }
        jj_consume_token(S);
      }
                           {if (true) return new LexicalUnitImpl(prev, LexicalUnit.SAC_OPERATOR_SLASH);}
      break;
    case COMMA:
      t = jj_consume_token(COMMA);
      label_29:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[45] = jj_gen;
          break label_29;
        }
        jj_consume_token(S);
      }
                           {if (true) return new LexicalUnitImpl(prev, LexicalUnit.SAC_OPERATOR_COMMA);}
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// combinator
//   : '+' S* | '>' S* |
//   ;
//
  final public char combinator() throws ParseException {
  char c = ' ';
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
      jj_consume_token(PLUS);
             c='+';
      label_30:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_30;
        }
        jj_consume_token(S);
      }
      break;
    case GT:
      jj_consume_token(GT);
           c='>';
      label_31:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[48] = jj_gen;
          break label_31;
        }
        jj_consume_token(S);
      }
      break;
    case S:
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case GT:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          jj_consume_token(PLUS);
                     c='+';
          break;
        case GT:
          jj_consume_token(GT);
                                       c='>';
          break;
        default:
          jj_la1[49] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_32:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[50] = jj_gen;
            break label_32;
          }
          jj_consume_token(S);
        }
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return c;}
    throw new Error("Missing return statement in function");
  }

//
// unary_operator
//   : '-' | '+'
//   ;
//
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      jj_consume_token(MINUS);
              {if (true) return '-';}
      break;
    case PLUS:
      jj_consume_token(PLUS);
                                       {if (true) return '+';}
      break;
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// property
//   : IDENT S*
//   ;
//
  final public String property() throws ParseException {
    Token t;
    t = jj_consume_token(IDENT);
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[54] = jj_gen;
        break label_33;
      }
      jj_consume_token(S);
    }
      {if (true) return unescape(t.image);}
    throw new Error("Missing return statement in function");
  }

//
// ruleset
//   : selector [ ',' S* selector ]*
//     '{' S* declaration [ ';' S* declaration ]* '}' S*
//   ;
//
  final public void styleRule() throws ParseException {
    SelectorList selList = null;
    boolean start = false;
    boolean noError = true;
    try {
      selList = selectorList();
      jj_consume_token(LBRACE);
      label_34:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_34;
        }
        jj_consume_token(S);
      }
            start = true;
            _docHandler.startSelector(selList);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      label_35:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_35;
        }
        jj_consume_token(SEMICOLON);
        label_36:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[58] = jj_gen;
            break label_36;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENT:
          declaration();
          break;
        default:
          jj_la1[59] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
    } catch (ParseException e) {
//        System.err.println("Exception in styleRule()");
//        System.err.println(e.getMessage());
        noError = false;
        error_skipblock();
    } finally {
        if (start) {
            _docHandler.endSelector(selList);
        }
    }
  }

  final public SelectorList selectorList() throws ParseException {
    SelectorListImpl selList = new SelectorListImpl();
    Selector sel;
    try {
      sel = selector();
      label_37:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[60] = jj_gen;
          break label_37;
        }
        jj_consume_token(COMMA);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case S:
            ;
            break;
          default:
            jj_la1[61] = jj_gen;
            break label_38;
          }
          jj_consume_token(S);
        }
                             selList.add(sel);
        sel = selector();
      }
            selList.add(sel);
            {if (true) return selList;}
    } catch (ParseException e) {
        System.err.println("Exception in selectorList()");
    }
    throw new Error("Missing return statement in function");
  }

//
// selector
//   : simple_selector [ combinator simple_selector ]*
//   ;
//
  final public Selector selector() throws ParseException {
    Selector sel;
    char comb;
    try {
      sel = simpleSelector(null, ' ');
      label_39:
      while (true) {
        if (jj_2_2(2)) {
          ;
        } else {
          break label_39;
        }
        comb = combinator();
        sel = simpleSelector(sel, comb);
      }
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[62] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
            {if (true) return sel;}
    } catch (ParseException e) {
        skipSelector();
    }
    throw new Error("Missing return statement in function");
  }

//
// simple_selector
//   : element_name? [ HASH | class | attrib | pseudo ]* S*
//   ;
//
  final public Selector simpleSelector(Selector sel, char comb) throws ParseException {
    SimpleSelector simpleSel = null;
    Condition c = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASTERISK:
    case IDENT:
      simpleSel = elementName();
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
        case COLON:
        case LSQUARE:
        case HASH:
          ;
          break;
        default:
          jj_la1[63] = jj_gen;
          break label_41;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HASH:
          c = hash(c);
          break;
        case DOT:
          c = _class(c);
          break;
        case LSQUARE:
          c = attrib(c);
          break;
        case COLON:
          c = pseudo(c);
          break;
        default:
          jj_la1[64] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    case DOT:
    case COLON:
    case LSQUARE:
    case HASH:
            simpleSel = _selectorFactory.createElementSelector(null, null);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case HASH:
          c = hash(c);
          break;
        case DOT:
          c = _class(c);
          break;
        case LSQUARE:
          c = attrib(c);
          break;
        case COLON:
          c = pseudo(c);
          break;
        default:
          jj_la1[65] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
        case COLON:
        case LSQUARE:
        case HASH:
          ;
          break;
        default:
          jj_la1[66] = jj_gen;
          break label_42;
        }
      }
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (c != null) {
            simpleSel = _selectorFactory.createConditionalSelector(simpleSel, c);
        }

        if (sel != null) {
            switch (comb) {
            case ' ':
                sel = _selectorFactory.createDescendantSelector(sel, simpleSel);
                break;
            case '+':
                sel = _selectorFactory.createDirectAdjacentSelector(sel.getSelectorType(), sel, simpleSel);
                break;
            case '>':
                sel = _selectorFactory.createChildSelector(sel, simpleSel);
                break;
            }
        } else {
            sel = simpleSel;
        }

        {if (true) return sel;}
    throw new Error("Missing return statement in function");
  }

//
// class
//   : '.' IDENT
//   ;
//
  final public Condition _class(Condition pred) throws ParseException {
    Token t;
    jj_consume_token(DOT);
    t = jj_consume_token(IDENT);
        Condition c = _conditionFactory.createClassCondition(null, t.image);
        {if (true) return (pred == null) ? c : _conditionFactory.createAndCondition(pred, c);}
    throw new Error("Missing return statement in function");
  }

//
// element_name
//   : IDENT | '*'
//   ;
//
  final public SimpleSelector elementName() throws ParseException {
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
    {if (true) return _selectorFactory.createElementSelector(null, unescape(t.image));}
      break;
    case ASTERISK:
      jj_consume_token(ASTERISK);
    {if (true) return _selectorFactory.createElementSelector(null, null);}
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

//
// attrib
//   : '[' S* IDENT S* [ [ '=' | INCLUDES | DASHMATCH ] S*
//     [ IDENT | STRING ] S* ]? ']'
//   ;
//
  final public Condition attrib(Condition pred) throws ParseException {
    Token t;
    String name = null;
    String value = null;
    int type = 0;
    jj_consume_token(LSQUARE);
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[69] = jj_gen;
        break label_43;
      }
      jj_consume_token(S);
    }
    t = jj_consume_token(IDENT);
                  name = unescape(t.image);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[70] = jj_gen;
        break label_44;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQUALS:
    case INCLUDES:
    case DASHMATCH:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUALS:
        jj_consume_token(EQUALS);
                       type = 1;
        break;
      case INCLUDES:
        jj_consume_token(INCLUDES);
                         type = 2;
        break;
      case DASHMATCH:
        jj_consume_token(DASHMATCH);
                          type = 3;
        break;
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[72] = jj_gen;
          break label_45;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        t = jj_consume_token(IDENT);
                          value = t.image;
        break;
      case STRING:
        t = jj_consume_token(STRING);
                           value = unescape(t.image);
        break;
      default:
        jj_la1[73] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[74] = jj_gen;
          break label_46;
        }
        jj_consume_token(S);
      }
      break;
    default:
      jj_la1[75] = jj_gen;
      ;
    }
    jj_consume_token(RSQUARE);
        Condition c = null;
        switch (type) {
        case 0:
            c = _conditionFactory.createAttributeCondition(name, null, false, null);
            break;
        case 1:
            c = _conditionFactory.createAttributeCondition(name, null, false, value);
            break;
        case 2:
            c = _conditionFactory.createOneOfAttributeCondition(name, null, false, value);
            break;
        case 3:
            c = _conditionFactory.createBeginHyphenAttributeCondition(name, null, false, value);
            break;
        }
        {if (true) return (pred == null) ? c : _conditionFactory.createAndCondition(pred, c);}
    throw new Error("Missing return statement in function");
  }

//
// pseudo
//   : ':' [ IDENT | FUNCTION S* IDENT S* ')' ]
//   ;
//
  final public Condition pseudo(Condition pred) throws ParseException {
    Condition c;
    Token t;
    String function;
    String arg;
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      t = jj_consume_token(IDENT);
            // There appears to be an issue here regarding "first-letter" & "first-line"
            String s = unescape(t.image);
                    c = _conditionFactory.createPseudoClassCondition(null, s);
            {if (true) return (pred == null)
                ? c
                : _conditionFactory.createAndCondition(pred, c);}
      break;
    case FUNCTION:
      t = jj_consume_token(FUNCTION);
                             function = unescape(t.image);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[76] = jj_gen;
          break label_47;
        }
        jj_consume_token(S);
      }
      t = jj_consume_token(IDENT);
                          arg = unescape(t.image);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[77] = jj_gen;
          break label_48;
        }
        jj_consume_token(S);
      }
      jj_consume_token(RROUND);
                if (function.equalsIgnoreCase("lang(")) {
                    c = _conditionFactory.createLangCondition(unescape(arg));
                    {if (true) return (pred == null)
                        ? c
                        : _conditionFactory.createAndCondition(pred, c);}
                } else {
                    {if (true) throw new CSSParseException(
                        "Invalid pseudo function name " + function,
                        getLocator());}
                }
      break;
    default:
      jj_la1[78] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Condition hash(Condition pred) throws ParseException {
    Token t;
    t = jj_consume_token(HASH);
        Condition c = _conditionFactory.createIdCondition(t.image.substring(1));
        {if (true) return (pred == null) ? c : _conditionFactory.createAndCondition(pred, c);}
    throw new Error("Missing return statement in function");
  }

  final public void styleDeclaration() throws ParseException {
    jj_consume_token(LBRACE);
    label_49:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[79] = jj_gen;
        break label_49;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENT:
      declaration();
      break;
    default:
      jj_la1[80] = jj_gen;
      ;
    }
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[81] = jj_gen;
        break label_50;
      }
      jj_consume_token(SEMICOLON);
      label_51:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[82] = jj_gen;
          break label_51;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENT:
        declaration();
        break;
      default:
        jj_la1[83] = jj_gen;
        ;
      }
    }
    jj_consume_token(RBRACE);
  }

//
// declaration
//   : property ':' S* expr prio?
//   |
//   ;
//
  final public void declaration() throws ParseException {
  String p;
  LexicalUnit e;
  boolean priority = false;
//  CSSValue e;
  boolean noError = true;
    try {
      p = property();
      jj_consume_token(COLON);
      label_52:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case S:
          ;
          break;
        default:
          jj_la1[84] = jj_gen;
          break label_52;
        }
        jj_consume_token(S);
      }
      e = expr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORTANT_SYM:
        priority = prio();
        break;
      default:
        jj_la1[85] = jj_gen;
        ;
      }
            _docHandler.property(p, e, priority);
    } catch (ParseException ex) {
        System.err.println("Exception in declaration()");
        noError = false;
        error_skipdecl();
    }
  }

//
// prio
//   : IMPORTANT_SYM S*
//   ;
//
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[86] = jj_gen;
        break label_53;
      }
      jj_consume_token(S);
    }
    {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

//
// expr
//   : term [ operator term ]*
//   ;
//
// TODO: Deal with the operator
//
  final public LexicalUnit expr() throws ParseException {
    LexicalUnit head;
    LexicalUnit body;
    head = term(null);
                        body = head;
    label_54:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case SLASH:
      case PLUS:
      case MINUS:
      case HASH:
      case STRING:
      case URI:
      case INHERIT:
      case EMS:
      case EXS:
      case LENGTH_PX:
      case LENGTH_CM:
      case LENGTH_MM:
      case LENGTH_IN:
      case LENGTH_PT:
      case LENGTH_PC:
      case ANGLE_DEG:
      case ANGLE_RAD:
      case ANGLE_GRAD:
      case TIME_MS:
      case TIME_S:
      case FREQ_HZ:
      case FREQ_KHZ:
      case DIMEN:
      case PERCENTAGE:
      case NUMBER:
      case RGB:
      case FUNCTION:
      case IDENT:
      case UNICODERANGE:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_54;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
      case SLASH:
        body = operator(body);
        break;
      default:
        jj_la1[88] = jj_gen;
        ;
      }
      body = term(body);
    }
      {if (true) return head;}
    throw new Error("Missing return statement in function");
  }

//
// term
//   : unary_operator?
//     [ NUMBER S* | PERCENTAGE S* | LENGTH S* | EMS S* | EXS S* | ANGLE S* |
//       TIME S* | FREQ S* | function ]
//   | STRING S* | IDENT S* | URI S* | RGB S* | UNICODERANGE S* | hexcolor
//   ;
//
  final public LexicalUnit term(LexicalUnit prev) throws ParseException {
  Token t;
  char op = ' ';
  String s;
  LexicalUnit value = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUS:
    case MINUS:
      op = unaryOperator();
      break;
    default:
      jj_la1[89] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EMS:
    case EXS:
    case LENGTH_PX:
    case LENGTH_CM:
    case LENGTH_MM:
    case LENGTH_IN:
    case LENGTH_PT:
    case LENGTH_PC:
    case ANGLE_DEG:
    case ANGLE_RAD:
    case ANGLE_GRAD:
    case TIME_MS:
    case TIME_S:
    case FREQ_HZ:
    case FREQ_KHZ:
    case PERCENTAGE:
    case NUMBER:
    case FUNCTION:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
                              value = LexicalUnitImpl.createNumber(prev, value(op, t.image));
        break;
      case PERCENTAGE:
        t = jj_consume_token(PERCENTAGE);
                              value = LexicalUnitImpl.createPercentage(prev, value(op, t.image));
        break;
      case LENGTH_PX:
        t = jj_consume_token(LENGTH_PX);
                              value = LexicalUnitImpl.createPixel(prev, value(op, t.image));
        break;
      case LENGTH_CM:
        t = jj_consume_token(LENGTH_CM);
                              value = LexicalUnitImpl.createCentimeter(prev, value(op, t.image));
        break;
      case LENGTH_MM:
        t = jj_consume_token(LENGTH_MM);
                              value = LexicalUnitImpl.createMillimeter(prev, value(op, t.image));
        break;
      case LENGTH_IN:
        t = jj_consume_token(LENGTH_IN);
                              value = LexicalUnitImpl.createInch(prev, value(op, t.image));
        break;
      case LENGTH_PT:
        t = jj_consume_token(LENGTH_PT);
                              value = LexicalUnitImpl.createPoint(prev, value(op, t.image));
        break;
      case LENGTH_PC:
        t = jj_consume_token(LENGTH_PC);
                              value = LexicalUnitImpl.createPica(prev, value(op, t.image));
        break;
      case EMS:
        t = jj_consume_token(EMS);
                              value = LexicalUnitImpl.createEm(prev, value(op, t.image));
        break;
      case EXS:
        t = jj_consume_token(EXS);
                              value = LexicalUnitImpl.createEx(prev, value(op, t.image));
        break;
      case ANGLE_DEG:
        t = jj_consume_token(ANGLE_DEG);
                              value = LexicalUnitImpl.createDegree(prev, value(op, t.image));
        break;
      case ANGLE_RAD:
        t = jj_consume_token(ANGLE_RAD);
                              value = LexicalUnitImpl.createRadian(prev, value(op, t.image));
        break;
      case ANGLE_GRAD:
        t = jj_consume_token(ANGLE_GRAD);
                              value = LexicalUnitImpl.createGradian(prev, value(op, t.image));
        break;
      case TIME_MS:
        t = jj_consume_token(TIME_MS);
                              value = LexicalUnitImpl.createMillisecond(prev, value(op, t.image));
        break;
      case TIME_S:
        t = jj_consume_token(TIME_S);
                              value = LexicalUnitImpl.createSecond(prev, value(op, t.image));
        break;
      case FREQ_HZ:
        t = jj_consume_token(FREQ_HZ);
                              value = LexicalUnitImpl.createHertz(prev, value(op, t.image));
        break;
      case FREQ_KHZ:
        t = jj_consume_token(FREQ_KHZ);
                              value = LexicalUnitImpl.createKiloHertz(prev, value(op, t.image));
        break;
      case FUNCTION:
        value = function(prev);
        break;
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case STRING:
      t = jj_consume_token(STRING);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_STRING_VALUE, t.image);
      break;
    case IDENT:
      t = jj_consume_token(IDENT);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_IDENT, t.image);
      break;
    case URI:
      t = jj_consume_token(URI);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_URI, t.image);
      break;
    case UNICODERANGE:
      t = jj_consume_token(UNICODERANGE);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_UNICODERANGE, t.image);
      break;
    case RGB:
      value = rgb(prev);
      break;
    case HASH:
      value = hexcolor(prev);
      break;
    case DIMEN:
      t = jj_consume_token(DIMEN);
        int n = getLastNumPos(t.image);
        value = LexicalUnitImpl.createDimension(
            prev,
            value(op, t.image.substring(0, n+1)),
            t.image.substring(n+1));
      break;
    case INHERIT:
      t = jj_consume_token(INHERIT);
                              value = new LexicalUnitImpl(prev, LexicalUnit.SAC_INHERIT, t.image);
      break;
    default:
      jj_la1[91] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_55:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[92] = jj_gen;
        break label_55;
      }
      jj_consume_token(S);
    }
      {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

//
// function
//   : FUNCTION S* expr ')' S*
//   ;
//
  final public LexicalUnit function(LexicalUnit prev) throws ParseException {
    Token t;
    LexicalUnit params;
    t = jj_consume_token(FUNCTION);
    label_56:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[93] = jj_gen;
        break label_56;
      }
      jj_consume_token(S);
    }
    params = expr();
    jj_consume_token(RROUND);
        if (t.image.equalsIgnoreCase("counter(")) {
           {if (true) return LexicalUnitImpl.createCounter(prev, params);}
        } else if (t.image.equalsIgnoreCase("counters(")) {
           {if (true) return LexicalUnitImpl.createCounters(prev, params);}
        } else if (t.image.equalsIgnoreCase("attr(")) {
           {if (true) return LexicalUnitImpl.createAttr(prev, params);}
        } else if (t.image.equalsIgnoreCase("rect(")) {
           {if (true) return LexicalUnitImpl.createRect(prev, params);}
        }
        {if (true) return LexicalUnitImpl.createFunction(
            prev,
            t.image.substring(0, t.image.length() - 1),
            params);}
    throw new Error("Missing return statement in function");
  }

//
// rgb
//   : RGB S* expr ')' S*
//   ;
//
  final public LexicalUnit rgb(LexicalUnit prev) throws ParseException {
    Token t;
    LexicalUnit params;
    t = jj_consume_token(RGB);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_57;
      }
      jj_consume_token(S);
    }
    params = expr();
    jj_consume_token(RROUND);
        {if (true) return LexicalUnitImpl.createRgbColor(prev, params);}
    throw new Error("Missing return statement in function");
  }

//
// hexcolor
//   : HASH S*
//   ;
//
  final public LexicalUnit hexcolor(LexicalUnit prev) throws ParseException {
    Token t;
    t = jj_consume_token(HASH);
        // Step past the hash at the beginning
        int i = 1;
        int r = 0;
        int g = 0;
        int b = 0;
        int len = t.image.length() - 1;

        if (len == 3) {
            r = Integer.parseInt(t.image.substring(i + 0, i + 1), 16);
            g = Integer.parseInt(t.image.substring(i + 1, i + 2), 16);
            b = Integer.parseInt(t.image.substring(i + 2, i + 3), 16);
            r = (r << 4) | r;
            g = (g << 4) | g;
            b = (b << 4) | b;
        } else if (len == 6) {
            r = Integer.parseInt(t.image.substring(i + 0, i + 2), 16);
            g = Integer.parseInt(t.image.substring(i + 2, i + 4), 16);
            b = Integer.parseInt(t.image.substring(i + 4, i + 6), 16);
        } else {
            // Error
        }

        // Turn into an "rgb()"
        LexicalUnit lr = LexicalUnitImpl.createNumber(null, r);
        LexicalUnit lc1 = LexicalUnitImpl.createComma(lr);
        LexicalUnit lg = LexicalUnitImpl.createNumber(lc1, g);
        LexicalUnit lc2 = LexicalUnitImpl.createComma(lg);
        LexicalUnit lb = LexicalUnitImpl.createNumber(lc2, b);

        {if (true) return LexicalUnitImpl.createRgbColor(prev, lr);}
    throw new Error("Missing return statement in function");
  }

  float value(char op, String s) throws ParseException {
    return ((op == '-') ? -1 : 1) * Float.parseFloat(s);
  }

  int getLastNumPos(String s) throws ParseException {
    int i;
    for (i = 0; i < s.length(); i++) {
        if (Character.isLetter(s.charAt(i))) {
            break;
        }
    }
    return i - 1;
  }

  String unescape(String s) throws ParseException {
    int len = s.length();
    StringBuffer buf = new StringBuffer(len);
    int index = 0;

    while (index < len) {
        char c = s.charAt(index);
        if (c == '\\') {
            if (++index < len) {
                c = s.charAt(index);
                switch (c) {
                case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
                case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
                case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
                    int numValue = Character.digit(c, 16);
                    int count = 0;
                    int p = 16;

                    while (index + 1 < len && count < 6) {
                        c = s.charAt(index+1);

                        if (Character.digit(c, 16) != -1) {
                            numValue = (numValue * 16) + Character.digit(c, 16);
                            p *= 16;
                            index++;
                        } else {
                            if (c == ' ') {
                                // skip the latest white space
                                index++;
                            }
                            break;
                        }
                    }
                    buf.append((char) numValue);
                    break;
                    case '\n':
                    case '\f':
                    break;
                    case '\r':
                    if (index + 1 < len) {
                        if (s.charAt(index + 1) == '\n') {
                            index ++;
                        }
                    }
                    break;
                default:
                    buf.append(c);
                }
            } else {
                throw new CSSParseException("invalid string " + s, getLocator());
            }
        } else {
            buf.append(c);
        }
        index++;
    }

    return buf.toString();
  }

  void skipSelector() throws ParseException {
    Token t = getToken(1);
    while (t.kind != COMMA && t.kind != SEMICOLON && t.kind != LBRACE && t.kind != EOF ) {
        getNextToken();
        t = getToken(1);
    }
  }

  String skip() throws ParseException {
  StringBuffer sb = new StringBuffer();
  int nesting = 0;
  Token t = getToken(0);
  if (t.image != null) {
    sb.append(t.image);
  }
  do {
    t = getNextToken();
    if (t.kind == EOF)
      break;
    sb.append(t.image);
    if (t.kind == LBRACE)
      nesting++;
    else if (t.kind == RBRACE)
      nesting--;
    else if (t.kind == SEMICOLON && nesting <= 0)
      break;
  }
  while ((t.kind != RBRACE) || (nesting > 0));

  return sb.toString();
  }

  void error_skipblock() throws ParseException {
  if (!_quiet) {
    ParseException e = generateParseException();
    System.err.println( "** error_skipblock **\n" + e.toString() );
  }

  Token t;
  int nesting = 0;
  do {
    t = getNextToken();
    if( t.kind == LBRACE )
      nesting++;
    else if( t.kind == RBRACE )
      nesting--;
    else if( t.kind == EOF )
      break;
  }
  while ((t.kind != RBRACE) || (nesting > 0));
  }

  void error_skipdecl() throws ParseException {
  if (!_quiet) {
    ParseException e = generateParseException();
    System.err.println("** error_skipdecl **\n" + e.toString());
  }

  Token t = getToken(1);
  while (t.kind != SEMICOLON && t.kind != RBRACE && t.kind != EOF ) {
      getNextToken();
      t = getToken(1);
  }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_3R_73() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_66() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) return true;
    }
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    if (jj_3R_67()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_67()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) return true;
    }
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(LSQUARE)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(IDENT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_58()) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) return true;
    }
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(ASTERISK)) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_79()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_78()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(GT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  public SACParserTokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[95];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x3000002,0x3000002,0x10000000,0x3000002,0x3000002,0xe00a0d00,0xe00a0d00,0x3000002,0x3000002,0xf00a0d00,0x2,0x2,0x2,0x900000,0x2,0x0,0x2,0x2,0x200a0d00,0x80,0x2,0x200a0d00,0x2,0x200a0d00,0x200a0d00,0x2,0x2,0x2,0x2,0x2,0x400,0x400,0x2,0x0,0x200,0x2,0x0,0x2,0x2,0x0,0x200,0x2,0x0,0x2,0x2,0x1080,0x2,0x2,0x12000,0x2,0x12000,0x12002,0x6000,0x2,0x2,0x0,0x200,0x2,0x0,0x80,0x2,0x2,0xa0500,0xa0500,0xa0500,0xa0500,0xa0d00,0x800,0x2,0x2,0xc008000,0x2,0x100000,0x2,0xc008000,0x2,0x2,0x0,0x2,0x0,0x200,0x2,0x0,0x2,0x0,0x2,0x987080,0x1080,0x6000,0x0,0x980000,0x2,0x2,0x2,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x1,0x0,0x0,0x0,0x0,0x0,0x1000002,0x1000002,0x0,0x0,0x1000003,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000002,0x0,0x0,0x1000002,0x0,0x1000002,0x1000002,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x1800000,0x0,0x1000000,0x0,0x0,0x1000000,0x0,0x4,0x0,0x9fffff8,0x0,0x0,0xb7fff0,0x9fffff8,0x0,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public SACParser(CharStream stream) {
    token_source = new SACParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 95; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 95; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public SACParser(SACParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 95; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(SACParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 95; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[78];
    for (int i = 0; i < 78; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 95; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 78; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
