#include <security/pam_modules.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include "pam_unixds.h"

/* syslogging function for errors and other information */
void
__pam_log (int err, const char *format,...)
{
  va_list args;
  char *str;

  va_start (args, format);
  if (vasprintf (&str, format, args) < 0)
    return;
  syslog (err, "pam_unixds: %s", str);
    va_end (args);
}

/**
  * Extract the boolean answer from the xmlrpc_value.
  */
int
get_boolean (xmlrpc_env * env, xmlrpc_value * in)
{
  int i;
  xmlrpc_parse_value (env, in, "b", &i);
  return i;
}

int
get_int (xmlrpc_env * env, xmlrpc_value * in)
{
  int i;
  xmlrpc_parse_value (env, in, "i", &i);
  return i;
}

/* this function ripped from pam_unix/support.c */
int converse(	pam_handle_t *pamh,
		int nargs, 
		struct pam_message **message,
		struct pam_response **response	) {
    int retval;
    struct pam_conv *conv;
    
    retval = pam_get_item(	pamh, PAM_CONV,  (const void **) &conv ) ; 
    if ( retval == PAM_SUCCESS ) {
	retval = conv->conv( 	nargs,  
				( const struct pam_message ** ) message, 
				response, 
				conv->appdata_ptr );
    }
    return retval;
}

/* this function ripped from pam_unix/support.c */
int _set_auth_tok(	pam_handle_t *pamh, 
			int flags, int argc, 
			const char **argv	) {
    int	retval;
    char	*p;
    
    struct pam_message msg[1],*pmsg[1];
    struct pam_response *resp;
    
    /* set up conversation call */
    
    pmsg[0] = &msg[0];
    msg[0].msg_style = PAM_PROMPT_ECHO_OFF;
    msg[0].msg = "UnixDS Password: ";
    resp = NULL;
    
    if ( ( retval = converse( pamh, 1 , pmsg, &resp ) ) != PAM_SUCCESS ) 
	return retval;
    
    if ( resp ) 
    {
	if ( ( flags & PAM_DISALLOW_NULL_AUTHTOK ) && 
	     resp[0].resp == NULL ) 
	{
	    free( resp );
	    return PAM_AUTH_ERR;
	}
	
	p = resp[ 0 ].resp;
	
	/* This could be a memory leak. If resp[0].resp 
	 is malloc()ed, then it has to be free()ed! 
	 -- alex 
	 */
	
	resp[ 0 ].resp = NULL; 		  				  
	
    } 
    else 
	return PAM_CONV_ERR;
    
    free( resp );
    pam_set_item( pamh, PAM_AUTHTOK, p );
    return PAM_SUCCESS;
}

