/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.operator.DFTPropertyGenerator;
import javax.media.jai.operator.JaiI18N;

public class DFTDescriptor
extends OperationDescriptorImpl {
    public static final Integer SCALING_NONE = new Integer(1);
    public static final Integer SCALING_UNITARY = new Integer(2);
    public static final Integer SCALING_DIMENSIONS = new Integer(3);
    public static final Integer REAL_TO_COMPLEX = new Integer(1);
    public static final Integer COMPLEX_TO_COMPLEX = new Integer(2);
    public static final Integer COMPLEX_TO_REAL = new Integer(3);
    private static final String[][] resources = new String[][]{{"GlobalName", "DFT"}, {"LocalName", "DFT"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("DFTDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/DFTDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("DFTDescriptor1")}, {"arg1Desc", JaiI18N.getString("DFTDescriptor2")}};
    private static final Class[] paramClasses = new Class[]{class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = DFTDescriptor.class$("java.lang.Integer")), class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = DFTDescriptor.class$("java.lang.Integer"))};
    private static final String[] paramNames = new String[]{"scalingType", "dataNature"};
    private static final Object[] paramDefaults = new Object[]{SCALING_NONE, REAL_TO_COMPLEX};
    static /* synthetic */ Class class$java$lang$Integer;

    public DFTDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] propertyGeneratorArray = new PropertyGenerator[]{new DFTPropertyGenerator()};
        return propertyGeneratorArray;
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public boolean validateArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        RenderedImage renderedImage;
        if (!super.validateArguments(parameterBlock, stringBuffer)) {
            return false;
        }
        Integer n = (Integer)parameterBlock.getObjectParameter(0);
        if (!(n.equals(SCALING_NONE) || n.equals(SCALING_UNITARY) || n.equals(SCALING_DIMENSIONS))) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("DFTDescriptor3"));
            return false;
        }
        Integer n2 = (Integer)parameterBlock.getObjectParameter(1);
        if (!(n2.equals(REAL_TO_COMPLEX) || n2.equals(COMPLEX_TO_COMPLEX) || n2.equals(COMPLEX_TO_REAL))) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("DFTDescriptor4"));
            return false;
        }
        if (!n2.equals(REAL_TO_COMPLEX) && (renderedImage = parameterBlock.getRenderedSource(0)).getSampleModel().getNumBands() % 2 != 0) {
            stringBuffer.append(String.valueOf(this.getName()) + " " + JaiI18N.getString("DFTDescriptor5"));
            return false;
        }
        return true;
    }
}

