/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.widget;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.RenderedImage;
import java.util.Vector;
import javax.media.jai.widget.ImageCanvas;
import javax.media.jai.widget.ViewportListener;

public class ScrollingImagePanel
extends ScrollPane
implements AdjustmentListener,
ComponentListener,
MouseListener,
MouseMotionListener {
    protected ImageCanvas ic;
    protected RenderedImage im;
    protected int panelWidth;
    protected int panelHeight;
    protected Vector viewportListeners = new Vector();
    protected Point moveSource;
    protected boolean beingDragged = false;
    protected Cursor defaultCursor = null;

    public ScrollingImagePanel(RenderedImage renderedImage, int n, int n2) {
        this.im = renderedImage;
        this.panelWidth = n;
        this.panelHeight = n2;
        this.ic = new ImageCanvas(renderedImage);
        this.getHAdjustable().addAdjustmentListener(this);
        this.getVAdjustable().addAdjustmentListener(this);
        super.setSize(n, n2);
        this.addComponentListener(this);
        this.add("Center", this.ic);
    }

    public void addViewportListener(ViewportListener viewportListener) {
        this.viewportListeners.addElement(viewportListener);
        viewportListener.setViewport(this.getXOrigin(), this.getYOrigin(), this.panelWidth, this.panelHeight);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.notifyViewportListeners(this.getXOrigin(), this.getYOrigin(), this.panelWidth, this.panelHeight);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private synchronized void endDrag() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.beingDragged = false;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.panelHeight);
    }

    public int getXCenter() {
        return this.getXOrigin() + this.panelWidth / 2;
    }

    public int getXOrigin() {
        return this.ic.getXOrigin();
    }

    public int getYCenter() {
        return this.getYOrigin() + this.panelHeight / 2;
    }

    public int getYOrigin() {
        return this.ic.getYOrigin();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateDrag(mouseEvent.getPoint());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.endDrag();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startDrag(mouseEvent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.endDrag();
    }

    private void notifyViewportListeners(int n, int n2, int n3, int n4) {
        int n5 = this.viewportListeners.size();
        int n6 = 0;
        while (n6 < n5) {
            ViewportListener viewportListener = (ViewportListener)this.viewportListeners.elementAt(n6);
            viewportListener.setViewport(n, n2, n3, n4);
            ++n6;
        }
    }

    public void removeViewportListener(ViewportListener viewportListener) {
        this.viewportListeners.removeElement(viewportListener);
    }

    public void set(RenderedImage renderedImage) {
        this.im = renderedImage;
        this.ic.set(renderedImage);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        int n5 = this.getViewportSize().width;
        int n6 = this.getViewportSize().height;
        int n7 = this.im.getWidth();
        int n8 = this.im.getHeight();
        if (n5 >= n7 && n6 >= n8) {
            this.ic.setBounds(n, n2, n3, n4);
        } else {
            this.ic.setBounds(n, n2, n5, n6);
        }
        this.panelWidth = n3;
        this.panelHeight = n4;
    }

    public synchronized void setCenter(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.im.getWidth();
        int n6 = this.im.getHeight();
        int n7 = this.getViewportSize().width;
        int n8 = this.getViewportSize().height;
        int n9 = this.getHAdjustable().getBlockIncrement();
        int n10 = this.getVAdjustable().getBlockIncrement();
        n3 = n < n7 - n5 / 2 ? 0 : (n > n5 / 2 ? n5 - n7 : n + (n5 - n7 - n9) / 2);
        n4 = n2 < n8 - n6 / 2 ? 0 : (n2 > n6 / 2 ? n6 - n8 : n2 + (n6 - n8 - n10) / 2);
        this.getHAdjustable().setValue(n3);
        this.getVAdjustable().setValue(n4);
        this.notifyViewportListeners(this.getXOrigin(), this.getYOrigin(), this.panelWidth, this.panelHeight);
    }

    public void setOrigin(int n, int n2) {
        this.ic.setOrigin(n, n2);
        this.notifyViewportListeners(n, n2, this.panelWidth, this.panelHeight);
    }

    private synchronized void startDrag(Point point) {
        this.setCursor(Cursor.getPredefinedCursor(13));
        this.beingDragged = true;
        this.moveSource = point;
    }

    protected synchronized void updateDrag(Point point) {
        if (this.beingDragged) {
            int n = this.moveSource.x - point.x;
            int n2 = this.moveSource.y - point.y;
            this.moveSource = point;
            int n3 = this.getHAdjustable().getValue() + n;
            int n4 = this.getVAdjustable().getValue() + n2;
            this.setOrigin(n3, n4);
        }
    }
}

